/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

public class TestResourceChangeUpdater
implements IResourceChangeUpdater {
    private TestNavigator testNavigator;
    private List addedObjects;
    private List removedObjects;
    private List changedObjects;
    private List resourcesToSave;
    private Object listToken = new Object();
    private List expandedElements;
    private List selectedElements;
    private boolean active;
    private boolean isDisposed = false;

    public TestResourceChangeUpdater(TestNavigator testNavigator) {
        this.testNavigator = testNavigator;
        this.active = true;
        this.isDisposed = false;
    }

    public void dispose() {
        this.active = false;
        this.isDisposed = true;
        this.testNavigator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() {
        Object object = this.listToken;
        synchronized (object) {
            this.addedObjects = new UniqueEList();
            this.removedObjects = new UniqueEList();
            this.changedObjects = new UniqueEList();
            this.resourcesToSave = new UniqueEList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ended() {
        Object finalCopyList;
        Object[] copyList = null;
        Object object = this.listToken;
        synchronized (object) {
            if (!this.addedObjects.isEmpty()) {
                copyList = this.addedObjects.toArray();
            }
        }
        if (copyList != null) {
            int i = 0;
            while (i < copyList.length) {
                Object parent;
                ITreeContentProvider treeContentProvider = (ITreeContentProvider)this.testNavigator.getViewer().getContentProvider();
                if (treeContentProvider != null) {
                    parent = treeContentProvider.getParent(copyList[i]);
                    if (parent == null) {
                        this.testNavigator.nodesChanged();
                        return;
                    }
                } else {
                    return;
                }
                this.testNavigator.nodeChanged(parent);
                ++i;
            }
        }
        copyList = null;
        Object i = this.listToken;
        synchronized (i) {
            if (!this.removedObjects.isEmpty()) {
                copyList = this.removedObjects.toArray();
            }
        }
        if (copyList != null) {
            finalCopyList = copyList;
            Display.getDefault().asyncExec(new Runnable((Object[])finalCopyList){
                private final /* synthetic */ Object[] val$finalCopyList;
                {
                    this.val$finalCopyList = objectArray;
                }

                public void run() {
                    if (!TestResourceChangeUpdater.this.testNavigator.getTreeViewer().getControl().isDisposed()) {
                        ITreeContentProvider treeContentProvider = (ITreeContentProvider)TestResourceChangeUpdater.this.testNavigator.getViewer().getContentProvider();
                        int i = 0;
                        while (i < this.val$finalCopyList.length) {
                            Object parent = treeContentProvider.getParent(this.val$finalCopyList[i]);
                            if (parent == null) {
                                TestResourceChangeUpdater.this.testNavigator.nodesChanged();
                                return;
                            }
                            TestResourceChangeUpdater.this.testNavigator.nodeChanged(parent);
                            ++i;
                        }
                    }
                }
            });
        }
        copyList = null;
        finalCopyList = this.listToken;
        synchronized (finalCopyList) {
            if (!this.changedObjects.isEmpty()) {
                copyList = this.changedObjects.toArray();
            }
        }
        if (copyList != null) {
            int i2 = 0;
            while (i2 < copyList.length) {
                this.testNavigator.nodeChanged(copyList[i2]);
                ++i2;
            }
        }
        copyList = null;
        Object i2 = this.listToken;
        synchronized (i2) {
            if (!this.resourcesToSave.isEmpty()) {
                copyList = this.resourcesToSave.toArray();
            }
        }
        if (copyList != null) {
            int i3 = 0;
            while (i3 < copyList.length) {
                try {
                    EMFUtil.save((Resource)((Resource)copyList[i3]));
                }
                catch (Exception exception) {}
                ++i3;
            }
        }
        Object object2 = this.listToken;
        synchronized (object2) {
            this.addedObjects.clear();
            this.addedObjects = null;
            this.removedObjects.clear();
            this.removedObjects = null;
            this.changedObjects.clear();
            this.changedObjects = null;
            this.resourcesToSave.clear();
            this.resourcesToSave = null;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (TestResourceChangeUpdater.this.expandedElements != null) {
                    TestResourceChangeUpdater.this.convertIdentifierToProxy(TestResourceChangeUpdater.this.expandedElements);
                    TestResourceChangeUpdater.this.testNavigator.getTreeViewer().setExpandedElements(TestResourceChangeUpdater.this.expandedElements.toArray());
                    TestResourceChangeUpdater.this.expandedElements = null;
                }
                if (TestResourceChangeUpdater.this.selectedElements != null) {
                    TestResourceChangeUpdater.this.convertIdentifierToProxy(TestResourceChangeUpdater.this.selectedElements);
                    TestResourceChangeUpdater.this.testNavigator.getTreeViewer().setSelection((ISelection)new StructuredSelection(TestResourceChangeUpdater.this.selectedElements), true);
                    TestResourceChangeUpdater.this.selectedElements = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IResource parent, IResource[] affectedResources) {
        int htnMode = this.testNavigator.getCurrentViewIndex();
        if (htnMode == 0) {
            int i = 0;
            int maxi = affectedResources.length;
            while (i < maxi) {
                if (affectedResources[i].getType() != 1) {
                    if (this.testNavigator.isVisibleResource(affectedResources[i])) {
                        Object object = this.listToken;
                        synchronized (object) {
                            this.addedObjects.add(affectedResources[i]);
                        }
                    }
                } else {
                    IContainer container = affectedResources[i].getParent();
                    Object object = this.listToken;
                    synchronized (object) {
                        this.changedObjects.add(container);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int maxi = affectedResources.length;
            while (i < maxi) {
                if (affectedResources[i].getType() == 4 && this.testNavigator.isVisibleResource(affectedResources[i])) {
                    Object object = this.listToken;
                    synchronized (object) {
                        this.addedObjects.add(affectedResources[i]);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IResource parent, IResource[] affectedResources) {
        int htnMode = this.testNavigator.getCurrentViewIndex();
        if (htnMode == 0) {
            int i = 0;
            int maxi = affectedResources.length;
            while (i < maxi) {
                if (affectedResources[i].getType() != 1) {
                    Object object = this.listToken;
                    synchronized (object) {
                        this.removedObjects.add(affectedResources[i]);
                    }
                }
                IProxyNode proxy = this.testNavigator.getCurrentFileProxyManager().getProxy((IFile)affectedResources[i], null);
                if (proxy != null) {
                    Object object = this.listToken;
                    synchronized (object) {
                        this.removedObjects.add(proxy);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int maxi = affectedResources.length;
            while (i < maxi) {
                if (affectedResources[i].getType() == 4) {
                    Object object = this.listToken;
                    synchronized (object) {
                        this.removedObjects.add(affectedResources[i]);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public boolean replaced(IResource affectedResource) {
        return false;
    }

    public boolean updateProperties(final IResource affectedResource) {
        if (affectedResource.getType() == 1) {
            final EObject[] eObjects = EMFUtil.getEObjects(null, (IFile)((IFile)affectedResource));
            if (eObjects.length > 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        TestResourceChangeUpdater.this.testNavigator.getTreeViewer().update((Object[])eObjects, null);
                    }
                });
            }
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TestResourceChangeUpdater.this.testNavigator.getTreeViewer().update((Object)affectedResource, null);
                }
            });
        }
        return false;
    }

    public boolean updateChildrenType(IResource affectedResource) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateContent(IResource parent, IResource affectedResource) {
        if (this.isDisposed) {
            return false;
        }
        if (affectedResource instanceof IFile && this.testNavigator.getCurrentViewIndex() == 0) {
            if (this.isDisposed) {
                return false;
            }
            IProxyNode proxy = this.testNavigator.getCurrentFileProxyManager().updateProxy((IFile)affectedResource, parent);
            if (proxy != null) {
                if (this.isDisposed) {
                    return false;
                }
                try {
                    this.testNavigator.getCurrentFileProxyManager().cacheProxy((IFile)affectedResource, proxy);
                }
                catch (Exception e) {
                    CommonPlugin.logError((Throwable)e);
                }
                Object object = this.listToken;
                synchronized (object) {
                    this.changedObjects.add(parent);
                }
            }
            if (this.changedObjects.size() > 0 && this.expandedElements == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        TestResourceChangeUpdater.this.expandedElements = new ArrayList();
                        Object[] expObjects = TestResourceChangeUpdater.this.testNavigator.getTreeViewer().getExpandedElements();
                        int counter = 0;
                        while (counter < expObjects.length) {
                            TestResourceChangeUpdater.this.expandedElements.add(expObjects[counter]);
                            ++counter;
                        }
                        TestResourceChangeUpdater.this.convertProxyToIdentifier(TestResourceChangeUpdater.this.expandedElements);
                        TestResourceChangeUpdater.this.selectedElements = ((IStructuredSelection)TestResourceChangeUpdater.this.testNavigator.getTreeViewer().getSelection()).toList();
                        TestResourceChangeUpdater.this.convertProxyToIdentifier(TestResourceChangeUpdater.this.selectedElements);
                    }
                });
            }
        }
        return false;
    }

    public void setActive(boolean enable) {
        this.active = enable;
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isValid(EObject eObject) {
        return eObject instanceof CMNNamedElement;
    }

    private void convertProxyToIdentifier(List objects) {
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof IProxyNode) {
                IProxyNode proxy = (IProxyNode)objects.get(i);
                objects.set(i, new ProxyIdentifier(proxy.getIdentifier(), proxy.getUnderlyingResource()));
            }
            ++i;
        }
    }

    private void convertIdentifierToProxy(List objects) {
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof ProxyIdentifier) {
                IProxyNode proxy;
                IProxyNode root;
                ProxyIdentifier ident = (ProxyIdentifier)objects.get(i);
                IResource res = ident.getUnderlyingResource();
                String fragment = ident.getIdentifier();
                IProxyNode iProxyNode = root = res instanceof IFile ? this.testNavigator.getCurrentFileProxyManager().getProxy((IFile)res, null) : null;
                if (root != null && (proxy = this.testNavigator.getCurrentFileProxyManager().findProxyByID(root, fragment)) != null) {
                    objects.set(i, proxy);
                }
            }
            ++i;
        }
    }

    public void refreshContent(final IResource affectedResource) {
        Control control = this.testNavigator.getTreeViewer().getControl();
        if (!control.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TestResourceChangeUpdater.this.testNavigator.getTreeViewer().refresh((Object)affectedResource);
                }
            });
        }
    }

    class ProxyIdentifier {
        private String identifier;
        private IResource underlyingResource;

        public ProxyIdentifier(String identifier, IResource res) {
            this.identifier = identifier;
            this.underlyingResource = res;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public IResource getUnderlyingResource() {
            return this.underlyingResource;
        }
    }
}

