/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ResourceTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNodeTransfer;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyAction
extends Action
implements IDisposable {
    private Clipboard clipboard;
    private IStructuredSelection selection;
    private boolean isResourceNav;

    public CopyAction(Clipboard clipboard) {
        super(UiPluginResourceBundle.command_Copy);
        if (clipboard == null) {
            throw new IllegalArgumentException("Unable to perform copy action due to 'clipboard == null'");
        }
        this.clipboard = clipboard;
        this.isResourceNav = false;
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
    }

    private void setClipboard() {
        try {
            this.clipboard.setContents(ClipboardManager.getInstance().getData(), ClipboardManager.getInstance().getTransfer());
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            UiPlugin.logError(e);
        }
    }

    private void copyOneResource(IResource res) {
        IPath location = res.getLocation();
        if (location != null) {
            ClipboardManager.getInstance().addFile(location.toOSString());
        }
        ClipboardManager.getInstance().addText(res.getName());
        ClipboardManager.getInstance().addResource(res);
    }

    private boolean isAFileProxy(IProxyNode proxy) {
        Object parent = ResourceTestNavigatorContentProvider.getSharedFileProxyManager().getParent(proxy);
        return proxy instanceof FileProxyNode || parent instanceof IContainer;
    }

    private void copyOneProxy(IProxyNode proxy) {
        if (this.isAFileProxy(proxy)) {
            IResource res = proxy.getUnderlyingResource();
            IPath location = res.getLocation();
            if (location != null) {
                ClipboardManager.getInstance().addFile(location.toOSString());
            }
            ClipboardManager.getInstance().addResource(res);
        }
        ClipboardManager.getInstance().addText(proxy.getText());
        ClipboardManager.getInstance().addProxy(proxy);
    }

    private void copySelection() {
        ClipboardManager.getInstance().clear();
        List allSelected = this.selection.toList();
        for (Object item : allSelected) {
            if (item instanceof IResource) {
                this.copyOneResource((IResource)item);
                continue;
            }
            if (!(item instanceof IProxyNode)) continue;
            this.copyOneProxy((IProxyNode)item);
        }
        this.setClipboard();
    }

    public void run() {
        this.copySelection();
    }

    private boolean selectionIsHomogeneous() {
        Object selItem2 = null;
        int flag = 0;
        int val = 0;
        for (Object selItem2 : this.selection) {
            if (selItem2 instanceof IProject) {
                val = 1;
            } else if (selItem2 instanceof IFolder) {
                val = 4;
            } else if (selItem2 instanceof IFile) {
                val = 8;
            } else if (selItem2 instanceof IProxyNode) {
                val = 16;
            } else {
                return false;
            }
            if (flag == 0) {
                flag = val;
                continue;
            }
            if ((flag ^= val) == 0) continue;
            return false;
        }
        return true;
    }

    private Object getParent(Object sel) {
        if (sel instanceof IResource) {
            IResource res = (IResource)sel;
            return res.getParent();
        }
        if (sel instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)sel;
            return ResourceTestNavigatorContentProvider.getSharedFileProxyManager().getParent(proxy);
        }
        return null;
    }

    private boolean selectionHasSameParent() {
        Object firstParent = this.getParent(this.selection.getFirstElement());
        if (firstParent == null) {
            return false;
        }
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            if (firstParent.equals(this.getParent(it.next()))) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableForSelection() {
        if (!this.isResourceNav) {
            return false;
        }
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        if (!this.selectionIsHomogeneous()) {
            return false;
        }
        return this.selectionHasSameParent();
    }

    public void selectionChanged(IStructuredSelection structuredSelection, boolean isResourceNav) {
        this.selection = structuredSelection;
        this.isResourceNav = isResourceNav;
    }

    static class ClipboardManager {
        private Map clipboardContent = new HashMap();
        private static ClipboardManager instance;

        private ClipboardManager() {
        }

        public static ClipboardManager getInstance() {
            if (instance == null) {
                instance = new ClipboardManager();
            }
            return instance;
        }

        public void addText(String text) {
            String content = "";
            if (this.clipboardContent.containsKey(TextTransfer.getInstance())) {
                content = (String)this.clipboardContent.get(TextTransfer.getInstance());
                text = String.valueOf(text) + "\n";
            }
            content = String.valueOf(content) + text;
            this.clipboardContent.put(TextTransfer.getInstance(), content);
        }

        public void addFile(String fileName) {
            List<Object> fileNames = this.clipboardContent.containsKey(FileTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get(FileTransfer.getInstance())) : new LinkedList();
            LinkedList<String> tmp = new LinkedList<String>(fileNames);
            tmp.add(fileName);
            this.clipboardContent.put(FileTransfer.getInstance(), tmp.toArray(new String[tmp.size()]));
        }

        public void addResource(IResource res) {
            List<Object> resources = this.clipboardContent.containsKey(ResourceTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get(ResourceTransfer.getInstance())) : new LinkedList();
            LinkedList<IResource> tmp = new LinkedList<IResource>(resources);
            tmp.add(res);
            this.clipboardContent.put(ResourceTransfer.getInstance(), tmp.toArray(new IResource[tmp.size()]));
        }

        public void addProxy(IProxyNode proxy) {
            List<Object> proxies = this.clipboardContent.containsKey((Object)ProxyNodeTransfer.getInstance()) ? Arrays.asList((Object[])this.clipboardContent.get((Object)ProxyNodeTransfer.getInstance())) : new LinkedList();
            LinkedList<IProxyNode> tmp = new LinkedList<IProxyNode>(proxies);
            tmp.add(proxy);
            this.clipboardContent.put(ProxyNodeTransfer.getInstance(), tmp.toArray(new IProxyNode[tmp.size()]));
        }

        public Object[] getData() {
            Transfer[] transfers = this.getTransfer();
            Object[] data = new Object[transfers.length];
            int i = 0;
            while (i < transfers.length) {
                data[i] = this.clipboardContent.get(transfers[i]);
                ++i;
            }
            return data;
        }

        public Transfer[] getTransfer() {
            Set transfers = this.clipboardContent.keySet();
            return transfers.toArray(new Transfer[transfers.size()]);
        }

        public void clear() {
            this.clipboardContent.clear();
        }
    }
}

