/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.action.EditorUtil;
import org.eclipse.hyades.test.ui.internal.navigator.action.resources.ActionMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteRefactoringWizard;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DeleteAction
extends SelectionListenerAction
implements IDisposable {
    private Shell shell;
    private LinkedList containers;
    private LinkedList proxies;

    public DeleteAction(Shell shell) {
        super(ActionMessages.DELETE_ACTION_NAME);
        this.shell = shell;
        this.containers = new LinkedList();
        this.proxies = new LinkedList();
    }

    public void run() {
        if (!this.canActivate(this.shell)) {
            return;
        }
        DeleteRefactoring refactoring = new DeleteRefactoring(this.containers, this.proxies);
        DeleteRefactoringWizard wizard = new DeleteRefactoringWizard(refactoring);
        wizard.setDefaultPageTitle(ActionMessages.DELETE_ACTION_NAME);
        wizard.setNeedsProgressMonitor(true);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(this.shell, "");
        }
        catch (InterruptedException e) {
            UiPlugin.logError(e);
        }
    }

    private boolean canActivate(Shell shell) {
        return EditorUtil.saveEditors(shell);
    }

    public void dispose() {
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean selOk = true;
        this.containers.clear();
        this.proxies.clear();
        Iterator it = selection.iterator();
        while (it.hasNext() && selOk) {
            Object o = it.next();
            if (o instanceof IContainer) {
                this.containers.add((IContainer)o);
                continue;
            }
            if (o instanceof IProxyNode) {
                IProxyNodeDeleter deleter = (IProxyNodeDeleter)((IProxyNode)o).getAdapter(IProxyNodeDeleter.class);
                selOk &= deleter != null;
                if (!(deleter instanceof IProxyNode)) continue;
                this.proxies.add(deleter);
                continue;
            }
            selOk = false;
        }
        return selOk;
    }

    public boolean isApplicableForSelection() {
        if (!this.containers.isEmpty() || !this.proxies.isEmpty()) {
            boolean oneNotProject = !this.proxies.isEmpty();
            boolean oneProject = false;
            for (IContainer cont : this.containers) {
                if (cont instanceof IProject) {
                    oneProject = true;
                } else {
                    oneNotProject = true;
                }
                if (!oneNotProject || !oneProject) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

