/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.action.ExecOpenEditorAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ExecToggleEObjectChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ExecToggleFolderAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.GenerateAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.NewActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.RunAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.StopAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.SuspendAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.TestConnectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FrameListActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorSorterActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.ToggleLinkingAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class ExecutionNavigatorActionGroup
extends NavigatorActionGroup {
    protected ExecOpenEditorAction openAction;
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected ExecToggleFolderAction toggleFolderAction;
    protected ExecToggleEObjectChildrenAction toggleEObjectChildren;
    protected GenerateAction generateAction;
    protected TestConnectionAction testConnectionAction;
    protected RunAction runAction;
    protected StopAction stopAction;
    protected SuspendAction suspendAction;
    protected DeleteResourceAction deleteResourceAction;
    protected RemoveChildrenAction deleteChildEObject;
    protected NavigatorSorterActionGroup sorterActionGroup;
    protected NewActionGroup newActionGroup;
    protected WorkingSetFilterActionGroup workingSetFilterActionGroup;
    protected FrameListActionGroup frameListActionGroup;

    public ExecutionNavigatorActionGroup(ExecutionNavigator execNavigator) {
        super((INavigator)execNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.workingSetFilterActionGroup.dispose();
        this.sorterActionGroup.dispose();
        this.frameListActionGroup.dispose();
        this.generateAction.dispose();
        this.testConnectionAction.dispose();
        this.runAction.dispose();
        this.stopAction.dispose();
        this.suspendAction.dispose();
        super.dispose();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.sorterActionGroup.setContext(context);
        this.newActionGroup.setContext(context);
        this.workingSetFilterActionGroup.setContext(context);
        this.frameListActionGroup.setContext(context);
    }

    protected void createActions() {
        super.createActions();
        Shell shell = this.getNavigator().getSite().getShell();
        this.openAction = new ExecOpenEditorAction((ExecutionNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_OPEN);
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)this.getNavigator().getViewer());
        this.collapseAllAction = new CollapseAllAction(((ITreeNavigator)this.getNavigator()).getTreeViewer());
        this.collapseAllAction.useDefaultDecorators();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.text"));
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleFolderAction = new ExecToggleFolderAction((ExecutionNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_SHOW_FLD_TXT);
        this.toggleFolderAction.setToolTipText(UiPluginResourceBundle.ACT_SHOW_FLD_DSC);
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleFolderAction, "showfolders_co.gif");
        this.toggleEObjectChildren = new ExecToggleEObjectChildrenAction((ExecutionNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_TXT);
        this.toggleEObjectChildren.setToolTipText(UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_DSC);
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleEObjectChildren, "showchild_co.gif");
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.deleteResourceAction = new DeleteResourceAction(shell);
        this.deleteResourceAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteResourceAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteResourceAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.deleteChildEObject = new RemoveChildrenAction(true){

            protected List saveResources(Set changedResources) {
                ExecutionNavigator execNavigator = (ExecutionNavigator)ExecutionNavigatorActionGroup.this.getNavigator();
                execNavigator.setMonitoringResourceChange(false);
                try {
                    List list = super.saveResources(changedResources);
                    return list;
                }
                finally {
                    execNavigator.setMonitoringResourceChange(true);
                }
            }
        };
        this.deleteChildEObject.setStructuredViewer(((ExecutionNavigator)this.getNavigator()).getViewer());
        this.deleteChildEObject.setShowErrorDialog(true);
        this.generateAction = new GenerateAction();
        this.testConnectionAction = new TestConnectionAction();
        this.runAction = new RunAction();
        this.stopAction = new StopAction();
        this.suspendAction = new SuspendAction();
    }

    protected void createActionGroups() {
        super.createActionGroups();
        this.sorterActionGroup = new NavigatorSorterActionGroup(this.getNavigator());
        this.newActionGroup = new NewActionGroup((ExecutionNavigator)this.getNavigator());
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    INavigator navigator = ExecutionNavigatorActionGroup.this.getNavigator();
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        ((ExecutionNavigator)navigator).setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        ((ExecutionNavigator)navigator).setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getNavigator().getViewer().getControl().getShell(), workingSetUpdater);
        this.workingSetFilterActionGroup.setWorkingSet(((ExecutionNavigator)this.getNavigator()).getWorkingSet());
        this.frameListActionGroup = new FrameListActionGroup((ITreeNavigator)((ExecutionNavigator)this.getNavigator()));
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resourceStructuredSelection = this.getResourceSelection(structuredSelection);
        this.newActionGroup.fillContextMenu(menu);
        this.frameListActionGroup.fillContextMenu(menu);
        this.openAction.selectionChanged(structuredSelection);
        if (this.openAction.isApplicableForSelection()) {
            menu.add((IAction)this.openAction);
            menu.add((IContributionItem)new Separator());
        }
        this.generateAction.selectionChanged(structuredSelection);
        if (this.generateAction.isApplicableForSelection()) {
            menu.add((IAction)this.generateAction);
        }
        this.testConnectionAction.selectionChanged(structuredSelection);
        if (this.testConnectionAction.isApplicableForSelection()) {
            menu.add((IAction)this.testConnectionAction);
        }
        this.runAction.selectionChanged(structuredSelection);
        if (this.runAction.isApplicableForSelection()) {
            menu.add((IAction)this.runAction);
        }
        this.stopAction.selectionChanged(structuredSelection);
        if (this.stopAction.isApplicableForSelection()) {
            menu.add((IAction)this.stopAction);
            this.stopAction.setEnabled(this.stopAction.isApplicableForEnablement());
        }
        this.suspendAction.selectionChanged(structuredSelection);
        if (this.suspendAction.isApplicableForSelection()) {
            menu.add((IAction)this.suspendAction);
            this.suspendAction.setEnabled(this.suspendAction.isApplicableForEnablement());
        }
        this.deleteResourceAction.setEnabled(false);
        if (resourceStructuredSelection.size() == structuredSelection.size()) {
            menu.add((IContributionItem)new Separator());
            this.deleteResourceAction.selectionChanged(resourceStructuredSelection);
            menu.add((IAction)this.deleteResourceAction);
            menu.add((IContributionItem)new Separator());
            this.addBookmarkAction.selectionChanged(resourceStructuredSelection);
            if (this.addBookmarkAction.isEnabled()) {
                menu.add((IAction)this.addBookmarkAction);
            }
        }
        if (!this.deleteResourceAction.isEnabled()) {
            menu.add((IContributionItem)new Separator());
            this.deleteChildEObject.selectionChanged(structuredSelection);
            if (this.deleteChildEObject.isEnabled()) {
                menu.add((IAction)this.deleteChildEObject);
            }
        }
        if (structuredSelection.size() == 1) {
            menu.add((IContributionItem)new Separator());
            this.propertyDialogAction.selectionChanged(structuredSelection);
            if (this.propertyDialogAction.isApplicableForSelection()) {
                menu.add((IAction)this.propertyDialogAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteResourceAction);
        this.frameListActionGroup.fillActionBars(actionBars);
        this.workingSetFilterActionGroup.fillActionBars(actionBars);
        this.sorterActionGroup.fillActionBars(actionBars);
        super.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        ExecutionNavigator execNavigator = (ExecutionNavigator)this.getNavigator();
        Object currentFrameInput = ((TreeFrame)execNavigator.getFrameList().getCurrentFrame()).getInput();
        this.toggleFolderAction.setEnabled(currentFrameInput == null || execNavigator.getInitialViewerInput() == currentFrameInput);
        this.toggleEObjectChildren.setEnabled(currentFrameInput == null || !(currentFrameInput instanceof EObject));
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resourceStructuredSelection = this.getResourceSelection(structuredSelection);
        this.propertyDialogAction.setEnabled(structuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(resourceStructuredSelection);
        this.deleteResourceAction.selectionChanged(resourceStructuredSelection);
        this.addTaskAction.selectionChanged(structuredSelection);
        this.frameListActionGroup.updateActionBars();
        this.sorterActionGroup.updateActionBars();
        this.workingSetFilterActionGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openAction.selectionChanged(selection);
        this.openAction.run();
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.deleteResourceAction.isEnabled()) {
            this.deleteResourceAction.run();
        }
        super.handleKeyPressed(event);
    }

    protected IStructuredSelection getResourceSelection(IStructuredSelection structuredSelection) {
        ExecutionNavigator execNavigator = (ExecutionNavigator)this.getNavigator();
        ArrayList resources = new ArrayList();
        for (Object object : structuredSelection) {
            if (object instanceof IResource && ((IResource)object).getType() != 1) {
                resources.add(object);
                continue;
            }
            IFile file = execNavigator.getFile(object);
            if (file == null) continue;
            resources.add(file);
        }
        return new StructuredSelection(resources);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

