/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ResourceTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IPaster;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class FileFolderInContainerPaste
implements IPaster {
    private IResource[] getResourceFromClipboard(final Clipboard clipboard) {
        final IResource[][] clipboardData = new IResource[1][];
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])clipboard.getContents((Transfer)resTransfer);
            }
        });
        return clipboardData[0];
    }

    public boolean isPasteAllowedFor(Clipboard clipboard, Object selection) {
        IResource[] res = this.getResourceFromClipboard(clipboard);
        if (res != null && res.length > 0) {
            int i = 0;
            while (i < res.length) {
                if (res[i].getType() != 2 && res[i].getType() != 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        TransferData[] transfers = clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i = 0;
        while (i < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPath getAutoNewNameFor(IPath originalName, IWorkspace workspace) {
        int counter = 1;
        String resourceName = originalName.lastSegment();
        IPath leadupSegment = originalName.removeLastSegments(1);
        while (true) {
            String nameSegment = counter > 1 ? NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameTwoArg, (Object)new Integer(counter), (Object)resourceName) : NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_NameOneArg, (Object)resourceName);
            IPath pathToTry = leadupSegment.append(nameSegment);
            if (!workspace.getRoot().exists(pathToTry)) {
                return pathToTry;
            }
            ++counter;
        }
    }

    private IPath getNewNameFor(final IPath originalName, final IWorkspace workspace) {
        final IResource resource = workspace.getRoot().findMember(originalName);
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        final String[] returnValue = new String[]{""};
        final Shell shell = Display.getCurrent().getActiveShell();
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String string) {
                        if (resource.getName().equals(string)) {
                            return TestNavigatorMessages.FileFolderInContainerPaste_ErrorSameName;
                        }
                        IStatus status = workspace.validateName(string, resource.getType());
                        if (!status.isOK()) {
                            return status.getMessage();
                        }
                        if (workspace.getRoot().exists(prefix.append(string))) {
                            return TestNavigatorMessages.FileFolderInContainerPaste_ErrorAlreadyExists;
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(shell, TestNavigatorMessages.FileFolderInContainerPaste_MessageTitle, NLS.bind((String)TestNavigatorMessages.FileFolderInContainerPaste_MessageLabel, (Object)resource.getName()), FileFolderInContainerPaste.this.getAutoNewNameFor(originalName, workspace).lastSegment().toString(), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            throw new OperationCanceledException();
        }
        String fileExt = resource.getFileExtension();
        if (fileExt != null && !returnValue[0].endsWith(fileExt)) {
            returnValue[0] = String.valueOf(returnValue[0]) + '.' + fileExt;
        }
        return prefix.append(returnValue[0]);
    }

    public boolean performPaste(Clipboard clipboard, Object selection) {
        if (selection instanceof IContainer) {
            FileTransfer fileTransfer;
            String[] fileData;
            IContainer dest = (IContainer)selection;
            IResource[] res = this.getResourceFromClipboard(clipboard);
            if (res != null && res.length > 0) {
                boolean oneCopied = false;
                int i = 0;
                while (i < res.length) {
                    IResource source = res[i];
                    boolean conflict = false;
                    if (source.getType() == 2 || source.getType() == 1) {
                        IPath destinationPath = dest.getFullPath().append(source.getName());
                        if (dest.findMember(source.getName()) != null) {
                            try {
                                destinationPath = this.getNewNameFor(destinationPath, source.getWorkspace());
                                conflict = true;
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                return true;
                            }
                        }
                        if (destinationPath != null) {
                            try {
                                source.copy(destinationPath, 32, (IProgressMonitor)new NullProgressMonitor());
                                oneCopied = true;
                                if (source instanceof IFile && conflict) {
                                    IFile file = source.getWorkspace().getRoot().getFile(destinationPath);
                                    IProxyNode proxy = ResourceTestNavigatorContentProvider.getSharedFileProxyManager().getProxy(file, null);
                                    IProxyNodeRenamer renamer = (IProxyNodeRenamer)proxy.getAdapter(IProxyNodeRenamer.class);
                                    if (renamer != null) {
                                        String newName = destinationPath.lastSegment().toString();
                                        newName = newName.substring(0, newName.length() - destinationPath.getFileExtension().length() - 1);
                                        renamer.performRename(newName);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                UiPlugin.logError(e);
                                return false;
                            }
                        }
                    }
                    ++i;
                }
                if (oneCopied) {
                    return true;
                }
            }
            if ((fileData = (String[])clipboard.getContents((Transfer)(fileTransfer = FileTransfer.getInstance()))) != null) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(Display.getCurrent().getActiveShell());
                operation.copyFiles(fileData, (IContainer)selection);
                return true;
            }
        }
        return false;
    }
}

