/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.action.CopyAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.DeleteAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.MoveAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.NewActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenEditorAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenWithActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.PasteAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.RenameAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.SelectAllAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.StopAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleEObjectChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleFolderAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleLinkingAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FrameListActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorSorterActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.views.framelist.TreeFrame;

public class TestNavigatorActionGroup
extends NavigatorActionGroup {
    private Clipboard clipboard;
    protected OpenEditorAction openAction;
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected ToggleFolderAction toggleFolderAction;
    protected ToggleEObjectChildrenAction toggleEObjectChildren;
    protected RefreshAction refreshAction;
    protected OpenResourceAction openProjectAction;
    protected CloseResourceAction closeProjectAction;
    protected StopAction stopAction;
    protected DeleteAction deleteAction;
    protected SelectAllAction selectAllAction;
    protected NavigatorSorterActionGroup sorterActionGroup;
    protected NewActionGroup newActionGroup;
    protected WorkingSetFilterActionGroup workingSetFilterActionGroup;
    protected FrameListActionGroup frameListActionGroup;
    protected RenameAction renameAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected MoveAction moveAction;
    protected OpenWithActionGroup openWithActionGroup;

    public TestNavigatorActionGroup(TestNavigator testNavigator) {
        super((INavigator)testNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.openWithActionGroup.dispose();
        this.workingSetFilterActionGroup.dispose();
        this.sorterActionGroup.dispose();
        this.frameListActionGroup.dispose();
        this.stopAction.dispose();
        this.renameAction.dispose();
        this.stopAction.dispose();
        this.pasteAction.dispose();
        this.moveAction.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.sorterActionGroup.setContext(context);
        this.newActionGroup.setContext(context);
        this.openWithActionGroup.setContext(context);
        this.workingSetFilterActionGroup.setContext(context);
        this.frameListActionGroup.setContext(context);
    }

    protected void createActions() {
        super.createActions();
        Shell shell = this.getNavigator().getSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.openAction = new OpenEditorAction((TestNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_OPEN);
        this.openAction.setActionDefinitionId("org.eclipse.hyades.test.ui.openCommand");
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)this.getNavigator().getViewer());
        this.propertyDialogAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.collapseAllAction = new CollapseAllAction(((ITreeNavigator)this.getNavigator()).getTreeViewer());
        this.collapseAllAction.useDefaultDecorators();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), TestNavigatorMessages.TestNavigatorActionGroup_ToggleAction_Text);
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleFolderAction = new ToggleFolderAction((TestNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_SHOW_FLD_TXT);
        this.toggleFolderAction.setToolTipText(UiPluginResourceBundle.ACT_SHOW_FLD_DSC);
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleFolderAction, "showfolders_co.gif");
        this.toggleEObjectChildren = new ToggleEObjectChildrenAction((TestNavigator)this.getNavigator(), UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_TXT);
        this.toggleEObjectChildren.setToolTipText(UiPluginResourceBundle.ACT_SHOW_EOBJ_CH_DSC);
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleEObjectChildren, "showchild_co.gif");
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = new DeleteAction(shell);
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.selectAllAction = new SelectAllAction(shell, ((ITreeNavigator)this.getNavigator()).getTreeViewer());
        this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.refreshAction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "refresh_nav.gif"));
        this.openProjectAction = new OpenResourceAction(shell){

            public void run() {
                super.run();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        block7: {
                            try {
                                TreeViewer testNavigatorTreeViewer = ((TestNavigator)TestNavigatorActionGroup.this.getNavigator()).getTreeViewer();
                                IStructuredSelection structuredSelection = (IStructuredSelection)testNavigatorTreeViewer.getSelection();
                                if (structuredSelection.size() != 1) break block7;
                                IProject project = null;
                                Object firstElement = structuredSelection.getFirstElement();
                                if (firstElement instanceof IProject) {
                                    project = (IProject)firstElement;
                                } else if (firstElement instanceof IAdaptable) {
                                    project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
                                }
                                if (project == null) break block7;
                                int counter = 0;
                                while (counter < 10) {
                                    if (project.isOpen()) {
                                        testNavigatorTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                        testNavigatorTreeViewer.setSelection((ISelection)structuredSelection);
                                        break;
                                    }
                                    Thread.sleep(200L);
                                    ++counter;
                                }
                            }
                            catch (Exception e) {
                                UiPlugin.logError(e);
                            }
                        }
                    }
                });
            }
        };
        this.closeProjectAction = new CloseResourceAction(shell){

            public void run() {
                super.run();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        block7: {
                            try {
                                TreeViewer testNavigatorTreeViewer = ((TestNavigator)TestNavigatorActionGroup.this.getNavigator()).getTreeViewer();
                                IStructuredSelection structuredSelection = (IStructuredSelection)testNavigatorTreeViewer.getSelection();
                                if (structuredSelection.size() != 1) break block7;
                                IProject project = null;
                                Object firstElement = structuredSelection.getFirstElement();
                                if (firstElement instanceof IProject) {
                                    project = (IProject)firstElement;
                                } else if (firstElement instanceof IAdaptable) {
                                    project = (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
                                }
                                if (project == null) break block7;
                                int counter = 0;
                                while (counter < 10) {
                                    if (!project.isOpen()) {
                                        testNavigatorTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                        testNavigatorTreeViewer.setSelection((ISelection)structuredSelection);
                                        break;
                                    }
                                    Thread.sleep(200L);
                                    ++counter;
                                }
                            }
                            catch (Exception e) {
                                UiPlugin.logError(e);
                            }
                        }
                    }
                });
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.openProjectAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeProjectAction);
        this.stopAction = new StopAction();
        this.renameAction = new RenameAction((TreeNavigator)this.getNavigator());
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.pasteAction = new PasteAction(shell, this.clipboard);
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.copyAction = new CopyAction(this.clipboard);
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.moveAction = new MoveAction(shell);
    }

    protected void createActionGroups() {
        super.createActionGroups();
        this.sorterActionGroup = new NavigatorSorterActionGroup(this.getNavigator());
        this.newActionGroup = new NewActionGroup((TestNavigator)this.getNavigator());
        this.openWithActionGroup = new OpenWithActionGroup((INavigator)((TestNavigator)this.getNavigator()));
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    INavigator navigator = TestNavigatorActionGroup.this.getNavigator();
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        ((TestNavigator)navigator).setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        ((TestNavigator)navigator).setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getNavigator().getViewer().getControl().getShell(), workingSetUpdater);
        this.workingSetFilterActionGroup.setWorkingSet(((TestNavigator)this.getNavigator()).getWorkingSet());
        this.frameListActionGroup = new FrameListActionGroup((ITreeNavigator)((TestNavigator)this.getNavigator()));
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        boolean hasClosedProjects = false;
        boolean hasOpenProjects = false;
        boolean isProjectSelection = true;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resSelection = this.getResourceSelection(selection);
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                project = (IProject)((IAdaptable)next).getAdapter(IProject.class);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                continue;
            }
            hasClosedProjects = true;
        }
        this.newActionGroup.fillContextMenu(menu);
        this.frameListActionGroup.fillContextMenu(menu);
        this.openAction.selectionChanged(selection);
        if (this.openAction.isApplicableForSelection()) {
            menu.appendToGroup("org.eclipse.ui.OpenWithSubMenu", (IAction)this.openAction);
        }
        this.openWithActionGroup.fillContextMenu(menu);
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.appendToGroup("group.refresh", (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.refresh", (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.refresh", (IAction)this.closeProjectAction);
            }
        }
        this.stopAction.selectionChanged(selection);
        if (this.stopAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.stopAction);
            this.stopAction.setEnabled(this.stopAction.isApplicableForEnablement());
        }
        boolean isResourceTestNav = ((TestNavigator)this.getNavigator()).getCurrentViewIndex() == 0;
        this.copyAction.selectionChanged(selection, isResourceTestNav);
        if (this.copyAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.copyAction);
        }
        this.pasteAction.selectionChanged(selection, isResourceTestNav);
        if (this.pasteAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.pasteAction);
        }
        this.moveAction.selectionChanged(selection, isResourceTestNav);
        if (this.moveAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.moveAction);
        }
        this.deleteAction.selectionChanged(selection);
        if (this.deleteAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.deleteAction);
        }
        if (this.selectAllAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.selectAllAction);
        }
        this.renameAction.selectionChanged(selection);
        if (this.renameAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.renameAction);
        }
        if (resSelection.size() == selection.size() && selection.size() > 0) {
            this.addBookmarkAction.selectionChanged(resSelection);
            if (this.addBookmarkAction.isEnabled()) {
                menu.appendToGroup("group.delete", (IAction)this.addBookmarkAction);
            }
        }
        if (selection.size() == 1) {
            this.propertyDialogAction.selectionChanged(selection);
            if (this.propertyDialogAction.isApplicableForSelection()) {
                menu.appendToGroup("group.properties", (IAction)this.propertyDialogAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.frameListActionGroup.fillActionBars(actionBars);
        this.newActionGroup.fillActionBars(actionBars);
        this.openWithActionGroup.fillActionBars(actionBars);
        this.workingSetFilterActionGroup.fillActionBars(actionBars);
        this.sorterActionGroup.fillActionBars(actionBars);
        super.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.toggleLinkingAction);
        menu.add((IAction)this.toggleEObjectChildren);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
        toolBar.add((IContributionItem)new Separator());
    }

    public void updateActionBars() {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        Object currentFrameInput = ((TreeFrame)testNavigator.getFrameList().getCurrentFrame()).getInput();
        this.toggleFolderAction.setEnabled(currentFrameInput == null || testNavigator.getInitialViewerInput() == currentFrameInput);
        this.toggleEObjectChildren.setEnabled(currentFrameInput == null || !(currentFrameInput instanceof EObject));
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resourceStructuredSelection = this.getResourceSelection(structuredSelection);
        this.propertyDialogAction.setEnabled(structuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(resourceStructuredSelection);
        this.deleteAction.selectionChanged(structuredSelection);
        this.addTaskAction.selectionChanged(structuredSelection);
        this.refreshAction.selectionChanged(structuredSelection);
        this.openProjectAction.selectionChanged(structuredSelection);
        this.closeProjectAction.selectionChanged(structuredSelection);
        boolean isResourceTestNav = ((TestNavigator)this.getNavigator()).getCurrentViewIndex() == 0;
        this.copyAction.selectionChanged(structuredSelection, isResourceTestNav);
        this.pasteAction.selectionChanged(structuredSelection, isResourceTestNav);
        this.moveAction.selectionChanged(structuredSelection, isResourceTestNav);
        this.renameAction.selectionChanged(structuredSelection);
        this.frameListActionGroup.updateActionBars();
        this.sorterActionGroup.updateActionBars();
        this.newActionGroup.updateActionBars();
        this.openWithActionGroup.updateActionBars();
        this.workingSetFilterActionGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openAction.selectionChanged(selection);
        this.openAction.run();
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        }
        if (event.keyCode == 0x100000C && event.stateMask == 0 && this.openAction.isEnabled()) {
            this.openAction.run();
            event.doit = false;
        }
        if (event.keyCode == 0x100000E && event.stateMask == 0 && this.refreshAction.isEnabled()) {
            this.refreshAction.run();
            event.doit = false;
        }
        if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
        super.handleKeyPressed(event);
    }

    protected IStructuredSelection getResourceSelection(IStructuredSelection structuredSelection) {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        ArrayList resources = new ArrayList();
        for (Object object : structuredSelection) {
            if (object instanceof IResource && ((IResource)object).getType() != 1) {
                resources.add(object);
                continue;
            }
            IFile file = testNavigator.getFile(object);
            if (file == null) continue;
            resources.add(file);
        }
        return new StructuredSelection(resources);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getBundle((String)"org.eclipse.ui").getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public IAction getRenameAction() {
        return this.renameAction;
    }

    public IAction getCopyAction() {
        return this.copyAction;
    }

    public IAction getPasteAction() {
        return this.pasteAction;
    }

    public IAction getRefreshAction() {
        return this.refreshAction;
    }

    public IAction getMoveAction() {
        return this.moveAction;
    }
}

