/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyNeedToBeRebuiltException;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DefaultExecutionResultProxyNode
extends TypedElementProxyNode
implements IExecutionResultProxyNode,
IPersistableProxyNode {
    private static final String TAG_VERDICT = "verdict";
    private static final String TAG_TIMESTAMP = "timestamp";
    private IProxyNode[] children;
    private int verdict;
    private long timestamp;
    private String cachedName;

    public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
        super(er, parent);
        this.children = new IProxyNode[0];
        String name = er.getName();
        String testName = null;
        TPFTest test = er.getTest();
        if (test != null) {
            testName = test.getName();
        }
        if (name != null) {
            if (testName != null && !testName.equals(name)) {
                name = String.valueOf(name) + " [" + testName + "]";
            }
        } else if (testName != null) {
            name = testName;
        }
        if (er.getTest() != null) {
            if (test instanceof TPFTestSuite) {
                IProxyNode proxy;
                if (er.getExecutionHistory().getExecutionEvents() != null && er.getExecutionHistory().getExecutionEvents().size() > 0) {
                    this.timestamp = ((TPFExecutionEvent)er.getExecutionHistory().getExecutionEvents().get(0)).getTimestamp();
                    String dateStamp = EventUtil.getTime(this.timestamp);
                    name = String.valueOf(name) + " [" + dateStamp + "]";
                }
                if ((proxy = FileProxyNodeCache.getInstance().getCorrespondingProxy(test)) != null) {
                    this.addBidirectionalReference("TestLog2TestSuite", (IReferencerProxyNode)proxy, "TestSuite2TestLog");
                }
            } else {
                name = String.valueOf(name) + " [" + er.getTest().getName() + "]";
            }
        }
        this.cachedName = name;
        this.verdict = er.getVerdict().getValue();
    }

    public DefaultExecutionResultProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
        Integer v = memento.getInteger(TAG_VERDICT);
        String l = memento.getString(TAG_TIMESTAMP);
        if (v == null || l == null) {
            throw new ProxyNeedToBeRebuiltException();
        }
        this.verdict = v;
        try {
            this.timestamp = Long.parseLong(l);
        }
        catch (NumberFormatException numberFormatException) {
            this.timestamp = 0L;
        }
        this.children = new IProxyNode[0];
        this.cachedName = this.getName();
    }

    public String getText() {
        if (this.timestamp != 0L) {
            if (this.cachedName == null) {
                String dateStamp = EventUtil.getTime(this.timestamp);
                this.cachedName = String.valueOf(super.getText()) + " [" + dateStamp + "]";
            }
            return this.cachedName;
        }
        return super.getText();
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("execution_obj.gif");
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public TPFExecutionResult getExecutionResult() {
        EObject exec = super.getEObject();
        if (exec instanceof TPFExecutionResult) {
            return (TPFExecutionResult)exec;
        }
        return null;
    }

    public int getVerdict() {
        return this.verdict;
    }

    protected String getNodeKind() {
        return "executionResultNode";
    }

    public String getFactoryID() {
        return "EMFResourceProxyFactory_4.3";
    }

    public boolean saveState(IMemento memento) {
        memento.putInteger(TAG_VERDICT, this.getVerdict());
        memento.putString(TAG_TIMESTAMP, Long.toString(this.timestamp));
        return super.saveState(memento);
    }
}

