/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode;
import org.eclipse.swt.graphics.Image;

public class DefaultTypeProviderProxyNode
extends TestFolderProxyNode
implements ITypeProviderProxyNode {
    private String type;
    private String name;
    private String imageKey;

    public DefaultTypeProviderProxyNode(IProject project, ITestFolderContentValidator customValidator, IFileProxyManager fileProxyManager, String type, Object parent) {
        super((IContainer)project, customValidator, fileProxyManager, false, parent);
        this.name = TestNavigator.getTypeProviderManager().getNameFor(type);
        if (this.name == null || this.name.length() == 0) {
            this.name = TestNavigator.getRegisteredTypeName(type);
        }
        this.type = type;
        this.imageKey = TestNavigator.getTypeProviderManager().getImageKeyFor(type);
    }

    public DefaultTypeProviderProxyNode(IProject project, IFileProxyManager fileProxyManager, String type, Object parent) {
        this(project, (ITestFolderContentValidator)new DefaultTestFolderContentValidator(type), fileProxyManager, type, parent);
    }

    public String getText() {
        return this.name;
    }

    public Image getImage() {
        if (this.imageKey == null || this.imageKey.length() == 0) {
            return super.getImage();
        }
        return UiPlugin.getInstance().getImageRegistry().get(this.imageKey);
    }

    public boolean isApplicableFor() {
        return false;
    }

    public IProxyNode resourceChanged(IResourceDelta delta) {
        return super.resourceChanged(delta);
    }

    public String getType() {
        return this.type;
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public static class DefaultTestFolderContentValidator
    implements ITestFolderContentValidator {
        private String type;
        private List extensions = new LinkedList();

        public DefaultTestFolderContentValidator(String type) {
            this.type = type;
            this.extensions.add("testsuite");
            this.extensions.add("execution");
            this.extensions.add("testcomponent");
        }

        public boolean isFileOk(IFile file) {
            return this.extensions.contains(file.getFileExtension());
        }

        public boolean isProxyOk(IProxyNode node) {
            if (node instanceof ITypedElementProxyNode) {
                return this.type.equals(((ITypedElementProxyNode)node).getType());
            }
            return false;
        }
    }
}

