/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.test.core.internal.util.EMFResourceReader;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ExecutionFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestComponentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestSuiteFileProxyNode;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

public class EMFResourceProxyFactory
implements IFileProxyFactory,
IPersistableFileProxyFactory {
    public static final String ID = "EMFResourceProxyFactory_4.3";

    public IProxyNode create(IFile file, Object parent) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        if (uri != null) {
            String extension = file.getFileExtension();
            if (extension != null && extension.trim().equalsIgnoreCase("datapool")) {
                Map datapoolProperties = EMFResourceReader.getRootProperties((IFile)file);
                String name = (String)datapoolProperties.get("name");
                String id = (String)datapoolProperties.get("id");
                if (name != null && name.trim().length() > 0 && id != null && id.trim().length() > 0) {
                    return new DatapoolProxyNode(name.trim(), (String)datapoolProperties.get("description"), uri.appendFragment(id.trim()), parent);
                }
            }
            Resource resource = null;
            if (file.exists()) {
                try {
                    resource = EMFUtil.getResource((ResourceSet)new ResourceSetImpl(), (URI)uri, (boolean)true);
                }
                catch (Exception exception) {}
                if (resource != null) {
                    try {
                        EObject[] eObjects = (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
                        if (eObjects.length == 1) {
                            IProxyNode iProxyNode = HyadesProxyNodeFactory.getInstance().create(eObjects[0], parent);
                            return iProxyNode;
                        }
                        if (eObjects.length > 1) {
                            FileProxyNode fileProxyNode = this.createFileProxy(file, resource);
                            return fileProxyNode;
                        }
                    }
                    finally {
                        resource.unload();
                    }
                }
            }
        }
        return null;
    }

    public IProxyNode recreate(IMemento memento, IFile file, Object parent) {
        IProxyNode proxy = HyadesProxyNodeFactory.getInstance().recreate(memento, parent);
        if (proxy == null) {
            String nodeKind = memento.getString("nodeKind");
            IMemento[] mementoChildren = memento.getChildren("childNode");
            int i = 0;
            while (i < mementoChildren.length) {
                IMemento mementoChild = mementoChildren[i];
                mementoChild.putString("uriRoot", memento.getString("uriRoot"));
                ++i;
            }
            if (nodeKind.equals("artifactFileNode")) {
                return new ArtifactFileProxyNode(file, memento);
            }
            if (nodeKind.equals("datapoolFileNode")) {
                return new DatapoolFileProxyNode(file, memento);
            }
            if (nodeKind.equals("deployFileNode")) {
                return new DeploymentFileProxyNode(file, memento);
            }
            if (nodeKind.equals("executionFileNode")) {
                return new ExecutionFileProxyNode(file, memento);
            }
            if (nodeKind.equals("locationFileNode")) {
                return new LocationFileProxyNode(file, memento);
            }
            if (nodeKind.equals("testComponentFileNode")) {
                return new TestComponentFileProxyNode(file, memento);
            }
            if (nodeKind.equals("testSuiteFileNode")) {
                return new TestSuiteFileProxyNode(file, memento);
            }
        } else {
            return proxy;
        }
        return null;
    }

    private FileProxyNode createFileProxy(IFile file, Resource resource) {
        String extension = file.getFileExtension();
        if (extension != null) {
            if (extension.equalsIgnoreCase("artifact")) {
                return new ArtifactFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("datapool")) {
                return new DatapoolFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("location")) {
                return new LocationFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("deploy")) {
                return new DeploymentFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("testsuite")) {
                return new TestSuiteFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("testcomponent")) {
                return new TestComponentFileProxyNode(file, resource);
            }
            if (extension.equalsIgnoreCase("execution")) {
                return new ExecutionFileProxyNode(file, resource);
            }
        }
        return null;
    }
}

