/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

public abstract class EMFResourceProxyNode
extends FileProxyNode
implements IPersistableProxyNode {
    private static final String TAG_NAME = "name";
    private List children;
    private String name;

    public EMFResourceProxyNode(IFile file, Resource resource) {
        super(file);
        this.children = new LinkedList();
        EObject[] eObjects = (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
        IProxyNode child = null;
        int i = 0;
        while (i < eObjects.length) {
            child = HyadesProxyNodeFactory.getInstance().create(eObjects[i], this);
            if (child != null) {
                this.children.add(child);
            }
            ++i;
        }
        this.name = file.getName();
        this.name = this.name.substring(0, this.name.length() - (file.getFileExtension().length() + 1));
    }

    public EMFResourceProxyNode(IFile file, IMemento rootMemento) {
        super(file);
        this.name = rootMemento.getString(TAG_NAME);
        this.children = new LinkedList();
        IProxyNode child = null;
        IMemento[] childrenState = rootMemento.getChildren("childNode");
        int i = 0;
        while (i < childrenState.length) {
            IMemento memento = childrenState[i];
            child = HyadesProxyNodeFactory.getInstance().recreate(memento, this);
            if (child != null) {
                this.children.add(child);
            }
            ++i;
        }
    }

    public IProxyNode[] getChildren() {
        return this.children.toArray(new IProxyNode[this.children.size()]);
    }

    public String getText() {
        return this.name;
    }

    protected boolean saveChildState(IMemento memento, IProxyNode child) {
        if (child instanceof IPersistableProxyNode) {
            IPersistableProxyNode proxy = (IPersistableProxyNode)child;
            IMemento childMemento = memento.createChild("childNode");
            return proxy.saveState(childMemento);
        }
        UiPlugin.logError("Child proxy node: " + child.getText() + " should be persistable");
        return false;
    }

    public String getFactoryID() {
        return "EMFResourceProxyFactory_4.3";
    }

    public boolean saveState(IMemento memento) {
        memento.putString("nodeKind", this.getNodeKind());
        memento.putString(TAG_NAME, this.getText());
        IProxyNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!this.saveChildState(memento, children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract String getNodeKind();
}

