/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFactoryManager {
    private Map<String, IFileProxyFactory> factoryIDToFactoryMap = new HashMap<String, IFileProxyFactory>();
    private Map<String, List<IFileProxyFactory>> fileExtensionToFactoriesMap = null;
    private Map<String, Boolean> fileExtensionToCase = new HashMap<String, Boolean>();

    public FileFactoryManager() {
        HashMap fileExtensionToFactoryIDsMap = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorFileProxyFactory");
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
            int counter = 0;
            while (counter < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[counter];
                if ("factory".equals(configurationElement.getName())) {
                    String factoryID = configurationElement.getAttribute("id");
                    String factoryClass = configurationElement.getAttribute("class");
                    if (factoryID == null || factoryID.trim().length() == 0) {
                        UiPlugin.logError("Unable to create the factory without an ID (id=\"" + factoryID + "\" class=\"" + factoryClass + "\").");
                    } else if (factoryClass == null || factoryClass.trim().length() == 0) {
                        UiPlugin.logError("Unable to create the factory without a class (id=\"" + factoryID + "\" class=\"" + factoryClass + "\").");
                    } else if (!this.factoryIDToFactoryMap.containsKey(factoryID)) {
                        try {
                            this.factoryIDToFactoryMap.put(factoryID, (IFileProxyFactory)configurationElement.createExecutableExtension("class"));
                        }
                        catch (CoreException e) {
                            UiPlugin.logError("Unable to create the factory instance (id=\"" + factoryID + "\" class=\"" + factoryClass + "\").", e);
                        }
                    } else {
                        UiPlugin.logError("Unable to create the factory with a previously registered factory ID (id=\"" + factoryID + "\" class=\"" + factoryClass + "\").");
                    }
                } else if ("file".equals(configurationElement.getName())) {
                    boolean caseSensitive;
                    String fileExtension = configurationElement.getAttribute("extension");
                    String factoryID = configurationElement.getAttribute("factoryID");
                    String caseSensitive_str = configurationElement.getAttribute("caseSensitive");
                    boolean bl = caseSensitive = caseSensitive_str == null ? true : Boolean.valueOf(caseSensitive_str);
                    if (fileExtension == null || fileExtension.trim().length() == 0) {
                        UiPlugin.logError("Unable to create the file without an extension (extension=\"" + fileExtension + "\" factoryID=\"" + factoryID + "\").");
                    } else if (factoryID == null || factoryID.trim().length() == 0) {
                        UiPlugin.logError("Unable to create the file without a factory ID (extension=\"" + fileExtension + "\" factoryID=\"" + factoryID + "\").");
                    } else {
                        ArrayList<String> factoryIDs;
                        if (!caseSensitive) {
                            fileExtension = fileExtension.toLowerCase();
                        }
                        if ((factoryIDs = (ArrayList<String>)fileExtensionToFactoryIDsMap.get(fileExtension)) == null) {
                            factoryIDs = new ArrayList<String>();
                            factoryIDs.add(factoryID);
                            fileExtensionToFactoryIDsMap.put(fileExtension, factoryIDs);
                            this.fileExtensionToCase.put(fileExtension, caseSensitive);
                        } else if (!factoryIDs.contains(factoryID)) {
                            factoryIDs.add(factoryID);
                        }
                    }
                }
                ++counter;
            }
        }
        this.fileExtensionToFactoriesMap = new HashMap<String, List<IFileProxyFactory>>();
        for (String fileExtension : fileExtensionToFactoryIDsMap.keySet()) {
            fileExtension = this.toLowercaseIfNotCaseSensitive(fileExtension);
            List factoryIDs = (List)fileExtensionToFactoryIDsMap.get(fileExtension);
            ArrayList<IFileProxyFactory> proxyFactories = new ArrayList<IFileProxyFactory>(factoryIDs.size());
            for (String factoryID : factoryIDs) {
                if (this.factoryIDToFactoryMap.containsKey(factoryID)) {
                    proxyFactories.add(this.factoryIDToFactoryMap.get(factoryID));
                    continue;
                }
                UiPlugin.logError("Unable to resolve the factory instance (id=\"" + factoryID + "\").");
            }
            this.fileExtensionToFactoriesMap.put(fileExtension, proxyFactories);
        }
    }

    private String toLowercaseIfNotCaseSensitive(String extension) {
        if (extension == null) {
            return extension;
        }
        Boolean caseSensitive = this.fileExtensionToCase.get(extension.toLowerCase());
        if (caseSensitive != null && !caseSensitive.booleanValue()) {
            return extension.toLowerCase();
        }
        return extension;
    }

    public List<IFileProxyFactory> getFactories(String fileExtension) {
        if (this.isRegistered(fileExtension)) {
            fileExtension = this.toLowercaseIfNotCaseSensitive(fileExtension);
            return this.fileExtensionToFactoriesMap.get(fileExtension);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isRegistered(String fileExtension) {
        if (fileExtension != null && fileExtension.trim().length() > 0) {
            fileExtension = this.toLowercaseIfNotCaseSensitive(fileExtension);
            return this.fileExtensionToFactoriesMap.containsKey(fileExtension);
        }
        return false;
    }

    public IFileProxyFactory getFactory(String id) {
        if (id != null && id.trim().length() > 0 && this.factoryIDToFactoryMap.containsKey(id)) {
            return this.factoryIDToFactoryMap.get(id);
        }
        return null;
    }

    public boolean isCaseSensitive(String extension) {
        if (extension == null) {
            return true;
        }
        Boolean caseSensitive = this.fileExtensionToCase.get(extension.toLowerCase());
        if (caseSensitive == null) {
            return true;
        }
        return caseSensitive;
    }
}

