/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyMarkerPersister;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFileProxyPersister;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class FileProxyNodeCache {
    protected static final NullProxy NULL_PROXY = new NullProxy();
    protected static final FileProxyManager.IUnboundedParent UNBOUNDED_PARENT = new UnboundedParent();
    private Map<IFile, IProxyNode> fileProxyNodes = new HashMap<IFile, IProxyNode>();
    private ResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private IFileProxyPersister defaultPersister = new FileProxyMarkerPersister();
    private Set<IResourceChangeListener> resourceListeners = Collections.synchronizedSet(new HashSet());
    private static FileProxyNodeCache instance = null;
    private static int referencesCount = 0;
    private static final ILock LOCK = Job.getJobManager().newLock();
    private static final IProxyNode[] NO_CHILDREN = new IProxyNode[0];

    private FileProxyNodeCache() {
    }

    public static FileProxyNodeCache getInstance() {
        if (instance == null) {
            instance = new FileProxyNodeCache();
        }
        ++referencesCount;
        return instance;
    }

    public void clearCache() {
        this.fileProxyNodes.clear();
    }

    public void dispose() {
        if (--referencesCount == 0) {
            this.fileProxyNodes.clear();
            this.resourceChangeListener.dispose();
            this.defaultPersister = null;
            this.resourceListeners.clear();
            instance = null;
        }
    }

    public void addResourceListener(IResourceChangeListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(IResourceChangeListener listener) {
        this.resourceListeners.remove(listener);
    }

    public IProxyNode createProxy(IFile file) {
        if (file != null && file.exists()) {
            IProxyNode proxyNode;
            block7: {
                proxyNode = null;
                try {
                    try {
                        LOCK.acquire();
                        this.fileProxyNodes.remove(file);
                        proxyNode = this.internalCreateProxy(file);
                    }
                    catch (Throwable t) {
                        UiPlugin.logError("Unable to create proxy for file '" + file.getFullPath().toString() + "'.", t);
                        proxyNode = new ErrorProxy(file);
                        LOCK.release();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    LOCK.release();
                    throw throwable;
                }
                LOCK.release();
            }
            if (proxyNode != NULL_PROXY) {
                return proxyNode;
            }
        }
        return null;
    }

    public IProxyNode getProxy(IFile file) {
        if (file != null) {
            IProxyNode proxyNode;
            block11: {
                proxyNode = this.fileProxyNodes.get(file);
                if (proxyNode == null && file.exists()) {
                    try {
                        try {
                            LOCK.acquire();
                            proxyNode = this.fileProxyNodes.get(file);
                            if (proxyNode == null) {
                                proxyNode = this.defaultPersister.loadProxy(file);
                                if (proxyNode != null) {
                                    this.fileProxyNodes.put(file, proxyNode);
                                } else {
                                    proxyNode = this.internalCreateProxy(file);
                                }
                            }
                        }
                        catch (Throwable t) {
                            UiPlugin.logError("Unable to create proxy for file '" + file.getFullPath().toString() + "'.", t);
                            proxyNode = new ErrorProxy(file);
                            LOCK.release();
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        LOCK.release();
                        throw throwable;
                    }
                    LOCK.release();
                }
            }
            if (proxyNode != NULL_PROXY) {
                return proxyNode;
            }
        }
        return null;
    }

    public IProxyNode getCorrespondingProxy(Object object) {
        if (object != null) {
            IProxyNode proxyNode;
            IResource resource;
            IProxy proxy = null;
            proxy = object instanceof IProxy ? (IProxy)object : (object instanceof IAdaptable ? (IProxy)((IAdaptable)object).getAdapter(IProxy.class) : (IProxy)Platform.getAdapterManager().getAdapter(object, IProxy.class));
            if (proxy != null && (resource = proxy.getUnderlyingResource()) instanceof IFile && (proxyNode = this.getProxy((IFile)resource)) != null) {
                return this.findProxyByID(proxyNode, proxy.getIdentifier());
            }
        }
        return null;
    }

    public IProxyNode findProxyByID(IProxyNode proxyNode, String id) {
        if (proxyNode != null) {
            if (id != null && id.trim().length() > 0) {
                if (proxyNode.getIdentifier().equals(id)) {
                    return proxyNode;
                }
                IProxyNode[] children = proxyNode.getChildren();
                int counter = 0;
                while (counter < children.length) {
                    proxyNode = this.findProxyByID(children[counter], id);
                    if (proxyNode != null) {
                        return proxyNode;
                    }
                    ++counter;
                }
            } else {
                return proxyNode;
            }
        }
        return null;
    }

    public boolean isCached(IFile file) {
        return this.getCachedProxy(file) != null;
    }

    public IProxyNode getCachedProxy(IFile file) {
        IProxyNode proxyNode = this.fileProxyNodes.get(file);
        if (proxyNode != NULL_PROXY) {
            return proxyNode;
        }
        return null;
    }

    public IProxyNode remove(IFile file) {
        IProxyNode proxyNode = this.fileProxyNodes.remove(file);
        if (proxyNode != NULL_PROXY) {
            return proxyNode;
        }
        return null;
    }

    private IProxyNode internalCreateProxy(IFile file) throws Throwable {
        IProxyNode proxyNode = null;
        List<IFileProxyFactory> fileProxyFactories = TestNavigator.getFileFactoryManager().getFactories(file.getFileExtension());
        if (fileProxyFactories.size() > 0) {
            for (IFileProxyFactory factory : fileProxyFactories) {
                try {
                    proxyNode = factory.create(file, UNBOUNDED_PARENT);
                }
                finally {
                    if (proxyNode == null) continue;
                }
                Assert.isLegal((boolean)file.equals(proxyNode.getAdapter(IFile.class)), (String)("Invalid proxy '" + proxyNode.getClass().getName() + "' returned by factory '" + factory.getClass().getName() + "' for file '" + file.getFullPath().toString() + "'."));
                break;
            }
        } else {
            proxyNode = NULL_PROXY;
        }
        if (proxyNode != null) {
            if (proxyNode instanceof IPersistableProxyNode) {
                this.defaultPersister.saveProxy(file, (IPersistableProxyNode)proxyNode);
            }
            this.fileProxyNodes.put(file, proxyNode);
        }
        return proxyNode;
    }

    private class ErrorProxy
    extends FileProxyNode {
        public ErrorProxy(IFile file) {
            super(file);
        }

        public String getText() {
            return String.valueOf(super.getText()) + " [" + TestNavigatorMessages.PROXY_LOADING_ERROR + "]";
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }

        public IProxyNode[] getChildren() {
            return NO_CHILDREN;
        }
    }

    protected static class NullProxy
    implements IPersistableProxyNode {
        private static final String FACTORY_ID = "org.eclipse.hyades.test.ui.nullFactory";

        protected NullProxy() {
        }

        public String getFactoryID() {
            return FACTORY_ID;
        }

        public boolean saveState(IMemento memento) {
            return true;
        }

        public IProxyNode[] getChildren() {
            return NO_CHILDREN;
        }

        public Image getImage() {
            return null;
        }

        public Object getParent() {
            return UNBOUNDED_PARENT;
        }

        public String getText() {
            return "<null proxy>";
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getIdentifier() {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        public ResourceChangeListener() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                IResourceChangeListener[] copy;
                Set set = FileProxyNodeCache.this.resourceListeners;
                synchronized (set) {
                    copy = FileProxyNodeCache.this.resourceListeners.toArray(new IResourceChangeListener[FileProxyNodeCache.this.resourceListeners.size()]);
                }
                int counter = 0;
                while (counter < copy.length) {
                    try {
                        copy[counter].resourceChanged(event);
                    }
                    catch (Throwable e) {
                        UiPlugin.logError(e);
                    }
                    ++counter;
                }
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    UiPlugin.logError(e);
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 4) {
                if (delta.getResource().getType() == 4 && (delta.getFlags() & 0x4000) != 0) {
                    IProject project = (IProject)delta.getResource();
                    if (!project.isOpen()) {
                        Iterator filesIterator = FileProxyNodeCache.this.fileProxyNodes.keySet().iterator();
                        while (filesIterator.hasNext()) {
                            if (!project.equals((Object)((IFile)filesIterator.next()).getProject())) continue;
                            filesIterator.remove();
                        }
                        return false;
                    }
                    TestUIUtilities.createProxyNodes((IContainer)project);
                }
                return delta.getResource().getType() != 1;
            }
            if (delta.getKind() == 2) {
                IResource resource = delta.getResource();
                if (resource.getType() == 1) {
                    FileProxyNodeCache.this.remove((IFile)resource);
                    ReferenceRegistry.getInstance().removeReferences((IFile)resource);
                } else {
                    if (resource.getType() == 4) {
                        ReferenceRegistry.getInstance().removeProjectReferenceRegistry((IProject)resource);
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class UnboundedParent
    implements FileProxyManager.IUnboundedParent {
        private UnboundedParent() {
        }
    }
}

