/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer2;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.ActionRefactoringFactory;
import org.eclipse.ltk.core.refactoring.Change;

public class NonEMFResourceProxyNode
extends FileProxyNode
implements IProxyNodeRenamer2,
IProxyNodeMover {
    private List children;
    private String name;

    public NonEMFResourceProxyNode(IFile file) {
        super(file);
        this.name = file.getName();
        this.name = this.name.substring(0, this.name.length() - (file.getFileExtension().length() + 1));
        this.children = new LinkedList();
    }

    public IProxyNode[] getChildren() {
        return this.children.toArray(new IProxyNode[this.children.size()]);
    }

    public String getText() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public Change createRenameChange(IRefactoringContext context, String newName) {
        String changedName = newName;
        IFile file = this.getFile();
        String extension = file.getFileExtension();
        if (extension != null && extension.length() != 0 && !changedName.endsWith(extension)) {
            changedName = String.valueOf(changedName) + "." + extension;
        }
        return ActionRefactoringFactory.getInstance().createRenameFileChange(this.getFile(), changedName);
    }

    public Change createMoveChange(IRefactoringContext context, IPath destinationPath) {
        IProject base = null;
        IPath basePath = destinationPath.removeLastSegments(1);
        if (basePath.segmentCount() == 1) {
            base = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.toString());
        }
        if (base == null || !base.exists()) {
            base = ResourcesPlugin.getWorkspace().getRoot().getFolder(basePath);
        }
        if (!base.exists()) {
            try {
                ((IFolder)base).create(true, true, null);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return ActionRefactoringFactory.getInstance().createMoveFileChange((IFile)this.getAdapter(IFile.class), (IContainer)base);
    }
}

