/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypeProviderManager;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestProvider
extends LabelProvider
implements ITreeContentProvider,
IProxyNodeListener {
    protected FileProxyManager fileProxyManager;
    private IFilter filter;
    protected TypeProviderManager manager;
    protected IProxyNodeListener proxyNodeListener;
    private Map projectToTypeProviders = new HashMap();

    public TestProvider(IFilter filter, final boolean allowUpdate) {
        this.fileProxyManager = new FileProxyManager(){

            public IProxyNode getProxy(IFile file, Object parent) {
                String ext = file.getFileExtension();
                if ("testsuite".equals(ext) || "java".equals(ext.toLowerCase())) {
                    return super.getProxy(file, parent);
                }
                return null;
            }
        };
        this.filter = filter;
        this.proxyNodeListener = allowUpdate ? new IProxyNodeListener(){

            public void nodeChanged(final Object node) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        TestProvider.this.nodeChanged(node);
                    }
                });
            }
        } : new IProxyNodeListener(){

            public void nodeChanged(Object node) {
            }
        };
        this.manager = new TypeProviderManager(new ITypeProviderContext(){

            public IProxyNodeListener getProxyNodeListener() {
                return TestProvider.this.proxyNodeListener;
            }

            public IFileProxyManager getFileProxyManager() {
                return TestProvider.this.fileProxyManager;
            }

            public boolean isStaticView() {
                return !allowUpdate;
            }
        });
    }

    public void addListener(IProxyNodeListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(IProxyNodeListener listener) {
        this.removeListenerObject(listener);
    }

    private List getTypeProviderProxyNodes(IProject project) {
        ArrayList<ITypeProviderProxyNode> result = (ArrayList<ITypeProviderProxyNode>)this.projectToTypeProviders.get(project);
        if (result == null) {
            result = new ArrayList<ITypeProviderProxyNode>();
            AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
            IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
            String[] types = associationMapping.getTypes();
            int i = 0;
            while (i < types.length) {
                ITypeProviderProxyNode proxy;
                IAssociationDescriptor descriptor;
                if (this.filter.satisfies(types[i]) && (descriptor = associationMapping.getDefaultAssociationDescriptor(types[i])) != null && (proxy = this.manager.getTypeProviderProxyNode(project, types[i])) != null) {
                    result.add(proxy);
                }
                ++i;
            }
            this.projectToTypeProviders.put(project, result);
        }
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            try {
                IContainer container = (IContainer)parentElement;
                IResource[] members = container.members();
                ArrayList<IResource> children = new ArrayList<IResource>(members.length);
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IProject && members[i].isAccessible() && !TestNavigator.getFiltersManager().filter(members[i])) {
                        children.add(members[i]);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return new Object[0];
            }
        }
        if (parentElement instanceof IProject) {
            List proxies = this.filterEmptyTypeProviderProxyNodes(this.getTypeProviderProxyNodes((IProject)parentElement));
            if (proxies.size() == 1) {
                return this.getChildren(proxies.get(0));
            }
            return proxies.toArray();
        }
        if (parentElement instanceof ITestSuiteProxyNode && this.filter.satisfiesChildren((ITestSuiteProxyNode)parentElement)) {
            ArrayList testCases = new ArrayList();
            this.collectTestCases(testCases, (ITestSuiteProxyNode)parentElement);
            return testCases.toArray();
        }
        if (parentElement instanceof IProxyNode && this.filter.satisfiesChildren((IProxyNode)parentElement)) {
            List proxies = this.filterProxyNodes(((IProxyNode)parentElement).getChildren());
            return proxies.toArray();
        }
        return new Object[0];
    }

    private List filterProxyNodes(IProxyNode[] proxies) {
        ArrayList<IProxyNode> ret = new ArrayList<IProxyNode>(proxies.length);
        int i = 0;
        while (i < proxies.length) {
            IProxyNode pn = proxies[i];
            if (this.filter.satisfies(pn) && (pn instanceof ITestSuiteProxyNode || this.getChildren(pn).length > 0)) {
                ret.add(pn);
            }
            ++i;
        }
        return ret;
    }

    private List filterEmptyTypeProviderProxyNodes(List proxies) {
        ArrayList<IProxyNode> ret = new ArrayList<IProxyNode>(proxies.size());
        for (IProxyNode pn : proxies) {
            if (pn.getChildren().length <= 0) continue;
            ret.add(pn);
        }
        return ret;
    }

    private void collectTestCases(List list, IProxyNode proxyNode) {
        IProxyNode[] children = proxyNode.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof ITestCaseProxyNode) {
                if (this.filter.satisfies(((ITestCaseProxyNode)children[i]).getType())) {
                    list.add(children[i]);
                }
            } else {
                this.collectTestCases(list, children[i]);
            }
            ++i;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof ITestCaseProxyNode) {
            return this.getParentTestSuiteProxyNode((ITestCaseProxyNode)element);
        }
        if (element instanceof IProxyNode) {
            ITypeProviderProxyNode dtpParent;
            IProject project;
            Object parent = this.fileProxyManager.getParent((IProxyNode)element);
            if (parent instanceof ITypeProviderProxyNode && this.filterEmptyTypeProviderProxyNodes(this.getTypeProviderProxyNodes(project = (IProject)(dtpParent = (ITypeProviderProxyNode)parent).getUnderlyingResource())).size() == 1) {
                return project;
            }
            return parent;
        }
        return null;
    }

    private Object getParentTestSuiteProxyNode(IProxyNode node) {
        Object parent = this.fileProxyManager.getParent(node);
        if (parent == null) {
            return null;
        }
        if (parent instanceof ITestSuiteProxyNode) {
            return parent;
        }
        if (parent instanceof IProxyNode) {
            return this.getParentTestSuiteProxyNode((IProxyNode)parent);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof IContainer) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null && (descriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
                return descriptor.createImage();
            }
        } else if (element instanceof IProxyNode) {
            return ((IProxyNode)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IContainer) {
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(element);
            }
        } else if (element instanceof IProxyNode) {
            return ((IProxyNode)element).getText();
        }
        return null;
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }

    public FileProxyManager getFileProxyManager() {
        return this.fileProxyManager;
    }

    public void dispose() {
        super.dispose();
        this.manager.dispose();
        this.fileProxyManager.dispose();
    }

    public IProxyNode getCorrespondingProxy(TPFTest test) {
        IResource res;
        IProxy proxy = (IProxy)test.getAdapter(IProxy.class);
        if (proxy != null && (res = proxy.getUnderlyingResource()) instanceof IFile) {
            this.getTypeProviderProxyNodes(res.getProject());
        }
        return this.fileProxyManager.getCorrespondingProxy(test);
    }

    public void nodeChanged(Object node) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ILabelProviderListener) {
                try {
                    ((ILabelProviderListener)listeners[i]).labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, node));
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
            } else if (listeners[i] instanceof IProxyNodeListener) {
                try {
                    ((IProxyNodeListener)listeners[i]).nodeChanged(node);
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
            }
            ++i;
        }
    }
}

