/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;

public class TypeProviderFactoryManager {
    private HashMap factories = new HashMap();
    private HashMap types = new HashMap();

    public TypeProviderFactoryManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorTypeProviderProxyFactory");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if ("factory".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    this.addFactory(id, element);
                } else if ("elementType".equals(element.getName())) {
                    String type = element.getAttribute("type");
                    String factoryID = element.getAttribute("factoryID");
                    if (type != null && type.length() != 0) {
                        this.addType(type, factoryID);
                    }
                }
                ++i;
            }
        }
    }

    private void addFactory(String id, IConfigurationElement element) {
        if (!this.factories.containsKey(id)) {
            this.factories.put(id, element);
        } else {
            UiPlugin.logInfo("ID: " + id + " already used in a previously registered factory");
        }
    }

    private void addType(String type, String factoryID) {
        if (!this.types.containsKey(type)) {
            this.types.put(type, factoryID);
        } else {
            UiPlugin.logInfo("type: " + type + " already registered");
        }
    }

    public ITypeProvider getFactory(String typeName) {
        if (this.types.containsKey(typeName)) {
            return this.getFactoryFromID((String)this.types.get(typeName));
        }
        return new DefaultTypeProvider();
    }

    public ITypeProvider getFactoryFromID(String factoryID) {
        Object value = this.factories.get(factoryID);
        if (value instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)value;
            try {
                ITypeProvider factory = null;
                factory = "factory".equals(element.getName()) ? (ITypeProvider)element.createExecutableExtension("class") : (ITypeProvider)element.createExecutableExtension("factory");
                return factory;
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return new DefaultTypeProvider();
            }
        }
        if (value instanceof ITypeProvider) {
            return (ITypeProvider)value;
        }
        UiPlugin.logError("internal error");
        return null;
    }
}

