/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTypeProvider;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ISynchronizedAccess;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.JobSynchronizedAccess;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderContext;
import org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.Bundle;

public class TypeProviderManager {
    private Map providers = Collections.synchronizedMap(new HashMap());
    private ITypeProviderContext context;

    public TypeProviderManager(ITypeProviderContext context) {
        this.context = context;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorTypeProvider");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if ("provider".equals(element.getName())) {
                    ImageDescriptor imageDescriptor;
                    ImageRegistry imageRegistry;
                    String imageKey;
                    String name = element.getAttribute("label");
                    if (name == null) {
                        name = element.getAttribute("name");
                    }
                    if ((imageKey = element.getAttribute("icon")) != null && (imageRegistry = UiPlugin.getInstance().getImageRegistry()).get(imageKey) == null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin((Bundle)Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier()), (String)imageKey)) != null) {
                        imageRegistry.put(imageKey, imageDescriptor);
                    }
                    this.addProvider(element.getAttribute("type"), new ExtensionTypeProviderInfo(name, imageKey, element));
                }
                ++i;
            }
        }
    }

    private void addProvider(String type, ITypeProviderInfo info) {
        if (!this.providers.containsKey(type)) {
            this.providers.put(type, info);
        } else {
            UiPlugin.logInfo("Provider for type: " + type + " already registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITypeProviderProxyNode getTypeProviderProxyNode(IProject project, String type) {
        Map map = this.providers;
        synchronized (map) {
            if (!this.providers.containsKey(type)) {
                this.addProvider(type, new DefaultTypeProviderInfo(type));
            }
        }
        ITypeProviderInfo info = (ITypeProviderInfo)this.providers.get(type);
        ITypeProvider provider = info.getProvider();
        try {
            if (info.acquireLock(project)) {
                ITypeProviderProxyNode iTypeProviderProxyNode = provider.get(project, type);
                return iTypeProviderProxyNode;
            }
            return null;
        }
        finally {
            info.releaseLock(project);
        }
    }

    public String getNameFor(String type) {
        if (this.providers.containsKey(type)) {
            return ((ITypeProviderInfo)this.providers.get(type)).getName();
        }
        return null;
    }

    public String getImageKeyFor(String type) {
        if (this.providers.containsKey(type)) {
            return ((ITypeProviderInfo)this.providers.get(type)).getImageKey();
        }
        return null;
    }

    public void dispose() {
        for (ITypeProviderInfo info : this.providers.values()) {
            ITypeProvider provider = info.getProvider();
            if (!(provider instanceof IDisposable)) continue;
            ((IDisposable)provider).dispose();
        }
    }

    class DefaultTypeProviderInfo
    extends JobSynchronizedAccess
    implements ITypeProviderInfo {
        private DefaultTypeProvider defaultTypeProvider = new DefaultTypeProvider();
        private String name;

        public DefaultTypeProviderInfo(String type) {
            this.defaultTypeProvider.init(TypeProviderManager.this.context);
            this.name = TestNavigator.getRegisteredTypeName(type);
        }

        public String getImageKey() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public ITypeProvider getProvider() {
            return this.defaultTypeProvider;
        }
    }

    class ExtensionTypeProviderInfo
    extends JobSynchronizedAccess
    implements ITypeProviderInfo {
        private String name;
        private String imageKey;
        private Object provider;

        public ExtensionTypeProviderInfo(String name, String imageKey, Object provider) {
            this.name = name;
            this.imageKey = imageKey;
            this.provider = provider;
        }

        public String getImageKey() {
            return this.imageKey;
        }

        public String getName() {
            return this.name;
        }

        public ITypeProvider getProvider() {
            if (this.provider instanceof ITypeProvider) {
                return (ITypeProvider)this.provider;
            }
            ITypeProvider p = null;
            try {
                p = (ITypeProvider)((IConfigurationElement)this.provider).createExecutableExtension("class");
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return null;
            }
            p.init(TypeProviderManager.this.context);
            this.provider = p;
            return p;
        }
    }

    static interface ITypeProviderInfo
    extends ISynchronizedAccess {
        public String getImageKey();

        public String getName();

        public ITypeProvider getProvider();
    }
}

