/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.DefaultTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;

public class TypedElementFactoryManager {
    private static TypedElementFactoryManager instance;
    private HashMap factories = new HashMap();
    private HashMap types = new HashMap();

    public static TypedElementFactoryManager getInstance() {
        if (instance == null) {
            instance = new TypedElementFactoryManager();
        }
        return instance;
    }

    private TypedElementFactoryManager() {
        IConfigurationElement element;
        int i;
        IConfigurationElement[] members;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorTypedElementProxyFactory");
        if (extPoint != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                element = members[i];
                if ("factory".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    this.addFactory(id, element);
                } else if ("typedElement".equals(element.getName())) {
                    String type = element.getAttribute("type");
                    String factoryID = element.getAttribute("factoryID");
                    if (type != null && type.length() != 0) {
                        this.addType(type, factoryID);
                    }
                }
                ++i;
            }
        }
        if ((extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorTypedElementFactory")) != null) {
            members = extPoint.getConfigurationElements();
            i = 0;
            while (i < members.length) {
                String typeName;
                element = members[i];
                if ("typedElement".equals(element.getName()) && (typeName = element.getAttribute("type")) != null && typeName.length() != 0) {
                    String id = element.getAttribute("factory");
                    this.addFactory(id, element);
                    this.addType(typeName, id);
                }
                ++i;
            }
        }
    }

    private void addFactory(String id, IConfigurationElement element) {
        if (!this.factories.containsKey(id)) {
            this.factories.put(id, element);
        } else {
            UiPlugin.logInfo("ID: " + id + " already used in a previously registered factory");
        }
    }

    private void addType(String type, String factoryID) {
        if (!this.types.containsKey(type)) {
            this.types.put(type, factoryID);
        } else {
            UiPlugin.logInfo("type: " + type + " already registered");
        }
    }

    public ITypedElementProxyFactory getFactory(String typeName) {
        if (this.types.containsKey(typeName)) {
            return this.getFactoryFromID((String)this.types.get(typeName));
        }
        return new DefaultTypedElementProxyFactory();
    }

    public ITypedElementProxyFactory getFactoryFromID(String factoryID) {
        Object value = this.factories.get(factoryID);
        if (value == null) {
            return null;
        }
        if (value instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)value;
            ITypedElementProxyFactory factory = null;
            try {
                factory = "factory".equals(element.getName()) ? (ITypedElementProxyFactory)element.createExecutableExtension("class") : (ITypedElementProxyFactory)element.createExecutableExtension("factory");
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                factory = new DefaultTypedElementProxyFactory();
            }
            this.factories.put(factoryID, factory);
            return factory;
        }
        if (value instanceof ITypedElementProxyFactory) {
            return (ITypedElementProxyFactory)value;
        }
        UiPlugin.logError("internal error");
        return null;
    }
}

