/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestAssetGroupProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypeProviderManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ProxiesRequest;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestNavigatorLogicalRefreshJob;
import org.eclipse.osgi.util.NLS;

public class LogicalProjectProxiesRequest
extends ProxiesRequest
implements ITestNavigatorLogicalRefreshJob {
    public static final String TYPE_PROVIDER_PREFIX = "#";
    public static final String TEST_ASSET_EXTENSION_PREFIX = "~";
    private IProject project;
    private TypeProviderManager typeProviderManager;
    private TestAssetGroupProxyManager testAssetGroupProxyManager;

    public LogicalProjectProxiesRequest(Collection requests, TypeProviderManager typeProviderManager, TestAssetGroupProxyManager testAssetGroupProxyManager, IProject project, TestNavigator testNavigator) {
        super(NLS.bind((String)TestNavigatorMessages.PM_EXPLORING_PROJECT, (Object)project.getName()), requests, testNavigator);
        this.project = project;
        this.typeProviderManager = typeProviderManager;
        this.testAssetGroupProxyManager = testAssetGroupProxyManager;
    }

    public IProject getProject() {
        return this.project;
    }

    protected IProxyNode computeProxy(Object key) {
        String req = (String)key;
        if (req.startsWith(TYPE_PROVIDER_PREFIX)) {
            return this.typeProviderManager.getTypeProviderProxyNode(this.project, req.substring(1));
        }
        if (req.startsWith(TEST_ASSET_EXTENSION_PREFIX)) {
            return this.testAssetGroupProxyManager.getTestAssetGroup(this.project, req.substring(1));
        }
        return null;
    }

    protected IProxyNode getPlaceHolder(Object key) {
        return null;
    }

    protected String getTaskName() {
        return NLS.bind((String)TestNavigatorMessages.PM_EXPLORING_PROJECT, (Object)this.project.getName());
    }

    protected String getSubTaskName(Object key) {
        String req = (String)key;
        if (req.startsWith(TYPE_PROVIDER_PREFIX)) {
            return NLS.bind((String)TestNavigatorMessages.PM_INDEXING_TYPE, (Object)req.substring(1));
        }
        if (req.startsWith(TEST_ASSET_EXTENSION_PREFIX)) {
            return NLS.bind((String)TestNavigatorMessages.PM_INDEXING_ASSET_GROUP, (Object)req.substring(1));
        }
        return "";
    }
}

