/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.IProxiesRequestListener;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.async.TestNavigatorJob;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ProxyRequestManager;
import org.eclipse.hyades.ui.util.IDisposable;

public abstract class ProxiesRequest
extends TestNavigatorJob
implements IDisposable {
    private IProxiesRequestListener listener;
    private List requests;
    private Map results = Collections.synchronizedMap(new HashMap());
    private boolean cancelled;
    private long lastNotificationTime;
    private long notificationInterval;
    private boolean notificationNeeded;
    private State state = new State();
    private boolean issueCancelNotification = false;

    protected ProxiesRequest(String name, Collection keys, TestNavigator testNavigator) {
        super(name, testNavigator);
        ProxyRequestManager.instance().startRequest(this);
        this.requests = new ArrayList(keys);
        for (Object key : keys) {
            IProxyNode proxy = this.getPlaceHolder(key);
            this.results.put(key, proxy);
        }
    }

    public IProxyNode getProxy(Object key) {
        return (IProxyNode)this.results.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wait(int timeOut, IProxiesRequestListener listener, int notificationInterval) throws OperationCanceledException {
        if (this.cancelled) {
            throw new OperationCanceledException();
        }
        State state = this.state;
        synchronized (state) {
            if (this.state.getState() != 3) {
                try {
                    this.state.wait(timeOut);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        switch (this.state.getState()) {
            case 0: 
            case 1: {
                this.notificationInterval = notificationInterval;
                this.listener = listener;
                this.lastNotificationTime = System.currentTimeMillis();
                return false;
            }
            case 3: {
                this.listener = listener;
                this.fireNotification(this.state);
                return true;
            }
            case 2: {
                throw new OperationCanceledException();
            }
        }
        throw new RuntimeException("Illegal internal state");
    }

    public boolean isPending() {
        int s = this.state.getState();
        return s == 0 || s == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.getTaskName(), this.requests.size());
        State state = this.state;
        synchronized (state) {
            this.state.set(1);
        }
        Thread.currentThread().setPriority(3);
        try {
            Iterator it = this.requests.iterator();
            while (!this.cancelled && it.hasNext()) {
                Object key = it.next();
                monitor.subTask(this.getSubTaskName(key));
                this._computeProxy(key);
                if (monitor.isCanceled()) {
                    this.cancelled = true;
                    continue;
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            State state2 = this.state;
            synchronized (state2) {
                this.state.set(this.cancelled ? 2 : 3);
                this.fireNotification(this.state);
                this.state.notifyAll();
            }
            monitor.done();
            throw throwable;
        }
        State state3 = this.state;
        synchronized (state3) {
            this.state.set(this.cancelled ? 2 : 3);
            this.fireNotification(this.state);
            this.state.notifyAll();
        }
        monitor.done();
        return new Status(0, "org.eclipse.hyades.test.ui", 0, "", null);
    }

    private void _computeProxy(Object key) {
        IProxyNode proxy = this.computeProxy(key);
        this.results.put(key, proxy);
        ProxyRequestManager.instance().endRequest(this);
        this.fireNotification(key);
    }

    protected abstract IProxyNode getPlaceHolder(Object var1);

    protected abstract IProxyNode computeProxy(Object var1);

    protected abstract String getTaskName();

    protected abstract String getSubTaskName(Object var1);

    private void fireNotification(Object key) {
        if (this.listener == null) {
            return;
        }
        try {
            if (key instanceof State) {
                if (this.state.getState() == 2) {
                    if (this.issueCancelNotification) {
                        this.listener.computationCancelled(this);
                    }
                } else {
                    if (this.notificationNeeded) {
                        this.listener.proxiesComputed(this);
                    }
                    this.listener.computationCompleted(this);
                }
            } else if (!this.cancelled) {
                this.listener.proxyComputed(this, key);
                long now = System.currentTimeMillis();
                if (this.lastNotificationTime + this.notificationInterval < now) {
                    this.listener.proxiesComputed(this);
                    this.notificationNeeded = false;
                    this.lastNotificationTime = now;
                } else {
                    this.notificationNeeded = true;
                }
            }
        }
        catch (Throwable t) {
            UiPlugin.logError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(int timeOut) {
        this.cancelled = true;
        State state = this.state;
        synchronized (state) {
            block6: {
                if (this.state.getState() != 1) break block6;
                try {
                    this.state.wait(timeOut);
                }
                catch (InterruptedException interruptedException) {}
                if (this.state.getState() != 1) break block6;
                this.issueCancelNotification = true;
                return false;
            }
            return true;
        }
    }

    public void dispose() {
        this.cancel(1);
    }

    private static class State {
        public static final int INITIALIZED = 0;
        public static final int RUNNING = 1;
        public static final int CANCELLED = 2;
        public static final int COMPLETED = 3;
        private int state = 0;

        private State() {
        }

        public void set(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }
}

