/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.IReferenceRegistrySavedState;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ProjectReferenceRegistry
implements ISaveParticipant {
    public static final String TAG_REFERENCE = "reference";
    public static final String TAG_REFERENCER = "referencer";
    public static final String TAG_REF_TYPE = "refType";
    private Map references = new HashMap();
    private boolean hasChanged = false;
    private IProject project;

    public ProjectReferenceRegistry(IProject project, IReferenceRegistrySavedState savedState) {
        IPath refsFilePath;
        this.project = project;
        if (savedState != null && (refsFilePath = savedState.lookup(this.getSavedStateFileKey())) != null) {
            File dependenciesFile = UiPlugin.getDefault().getStateLocation().append(refsFilePath).toFile();
            try {
                this.load(new GZIPInputStream(new BufferedInputStream(new FileInputStream(dependenciesFile))));
            }
            catch (Throwable t) {
                this.clear();
                UiPlugin.logWarning("Unable to load proxy node references file for project " + this.project.getName(), t);
            }
        }
    }

    private void addReference(IFile referencer, Reference ref) {
        Assert.isNotNull((Object)ref);
        HashSet<Reference> refs = (HashSet<Reference>)this.references.get(referencer);
        if (refs == null) {
            refs = new HashSet<Reference>();
            this.references.put(referencer, refs);
        }
        refs.add(ref);
        this.hasChanged = true;
    }

    public void addReference(IFile referencer, String refType, IFile referenced) {
        this.addReference(referencer, new Reference(refType, referenced));
    }

    public void addBidirectionalReference(IFile referencer, String refType, IFile referenced, String oppositeRefType) {
        this.addReference(referencer, refType, referenced);
        this.addReference(referenced, oppositeRefType, referencer);
    }

    public void removeReference(IFile referencer, IFile referenced) {
        Assert.isNotNull((Object)referenced);
        Collection refs = (Collection)this.references.get(referencer);
        if (refs != null) {
            Iterator it = refs.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                if (!referenced.equals((Object)ref.getReferenced())) continue;
                it.remove();
                this.hasChanged = true;
            }
        }
    }

    public void removeReferences(IFile referencer) {
        this.references.remove(referencer);
    }

    public Collection getReferences(IFile referencer, String refType) {
        Assert.isNotNull((Object)refType, (String)"type should be not null");
        Collection refs = (Collection)this.references.get(referencer);
        if (refs != null) {
            LinkedList<IProxyNode> res = new LinkedList<IProxyNode>();
            for (Reference ref : refs) {
                IProxyNode proxy;
                if (!refType.equals(ref.getType()) || (proxy = FileProxyNodeCache.getInstance().getProxy(ref.getReferenced())) == null) continue;
                res.add(proxy);
            }
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getAllReferences(IFile referencer) {
        Collection list = (Collection)this.references.get(referencer);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public Set getReferencerFiles() {
        HashSet<IFile> res = new HashSet<IFile>();
        Set keys = this.references.keySet();
        if (keys != null) {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                res.add((IFile)it.next());
            }
        }
        return res;
    }

    public Set getReferenceTypes(IFile referencer) {
        HashSet<String> res = new HashSet<String>();
        Collection refs = (Collection)this.references.get(referencer);
        if (refs != null) {
            for (Reference ref : refs) {
                res.add(ref.getType());
            }
        }
        return res;
    }

    public void clear() {
        this.references.clear();
        this.hasChanged = false;
    }

    private File getPersistenceFile(int saveNumber) {
        if (!this.project.exists()) {
            return null;
        }
        String depsFileName = String.valueOf(this.project.getName()) + ".references-" + Integer.toString(saveNumber);
        return UiPlugin.getDefault().getStateLocation().append(depsFileName).toFile();
    }

    private IPath getSavedStateFileKey() {
        return new Path("references").append(this.project.getName());
    }

    public void doneSaving(ISaveContext context) {
        if (this.hasChanged) {
            this.hasChanged = false;
            File depsFile = this.getPersistenceFile(context.getPreviousSaveNumber());
            if (depsFile.exists()) {
                depsFile.delete();
            }
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
        File file = this.getPersistenceFile(context.getSaveNumber());
        if (file.exists()) {
            file.delete();
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (this.hasChanged && this.project.exists()) {
            int saveNumber = context.getSaveNumber();
            File depsFile = this.getPersistenceFile(saveNumber);
            try {
                this.save(depsFile);
                context.map(this.getSavedStateFileKey(), (IPath)new Path(depsFile.getName()));
                context.needSaveNumber();
            }
            catch (IOException e) {
                UiPlugin.logError("Unexpected exception during references saving operation.", e);
            }
        }
    }

    private void load(InputStream stream) throws WorkbenchException, IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        reader.close();
        IMemento[] referencers = memento.getChildren(TAG_REFERENCER);
        int i = 0;
        while (i < referencers.length) {
            String underlyingResName = referencers[i].getString("underlyingResource");
            IFile refFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)underlyingResName));
            if (refFile != null) {
                this.loadProxyReferences(refFile, referencers[i]);
            }
            ++i;
        }
    }

    private void loadProxyReferences(IFile file, IMemento memento) {
        IMemento[] refStates = memento.getChildren(TAG_REFERENCE);
        int j = 0;
        while (j < refStates.length) {
            IMemento refMemento = refStates[j];
            String underlyingResName = refMemento.getString("underlyingResource");
            String refType = refMemento.getString(TAG_REF_TYPE);
            IFile refFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)underlyingResName));
            if (refFile.exists()) {
                this.addReference(file, new Reference(refType, refFile));
            } else {
                this.hasChanged = true;
            }
            ++j;
        }
    }

    private void save(File depsFile) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(depsFile))));
        XMLMemento memento = XMLMemento.createWriteRoot((String)"references");
        Iterator it = this.references.keySet().iterator();
        while (it.hasNext()) {
            this.saveProxyReferences((IFile)it.next(), (IMemento)memento);
        }
        memento.save((Writer)writer);
        writer.close();
    }

    private void saveProxyReferences(IFile file, IMemento memento) {
        IMemento referencerMemento = memento.createChild(TAG_REFERENCER);
        referencerMemento.putString("underlyingResource", file.getFullPath().toPortableString());
        for (Reference ref : this.getAllReferences(file)) {
            IMemento referenceMemento = referencerMemento.createChild(TAG_REFERENCE);
            referenceMemento.putString(TAG_REF_TYPE, ref.getType());
            referenceMemento.putString("underlyingResource", ref.getReferenced().getFullPath().toPortableString());
        }
    }

    class Reference {
        private String type;
        private IFile referenced;

        public Reference(String typeRef, IFile referenced) {
            this.type = typeRef;
            this.referenced = referenced;
        }

        public IFile getReferenced() {
            return this.referenced;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object arg0) {
            if (arg0 == this) {
                return true;
            }
            if (arg0 instanceof Reference) {
                Reference ref = (Reference)arg0;
                if (this.type != null && this.referenced != null) {
                    return this.type.equals(ref.type) && this.referenced.equals((Object)ref.referenced);
                }
                if (this.type == null && ref.type == null || this.referenced == null && ref.referenced == null) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.referenced != null ? this.referenced.hashCode() : -1;
        }
    }
}

