/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.Proxy;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

public class Reference {
    private String type;
    private String proxyId;
    private IFile proxyFile;

    public Reference(String type, String proxyId, IFile proxyFile) {
        if (type == null || proxyId == null || proxyFile == null) {
            throw new IllegalArgumentException("Can not create reference with null value");
        }
        this.type = type;
        this.proxyId = proxyId;
        this.proxyFile = proxyFile;
    }

    public Reference(String type, IProxy proxy) {
        IResource ulr = proxy.getUnderlyingResource();
        if (ulr instanceof IFile) {
            this.proxyFile = (IFile)ulr;
        }
        this.type = type;
        this.proxyId = proxy.getIdentifier();
    }

    public IProxyNode getReferencedProxy() {
        return FileProxyNodeCache.getInstance().getCorrespondingProxy(new Proxy((IResource)this.proxyFile, this.proxyId));
    }

    public String getType() {
        return this.type;
    }

    public IFile getProxyFile() {
        return this.proxyFile;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 instanceof Reference) {
            Reference ref = (Reference)arg0;
            return ref.type.equals(this.type) && ref.proxyId.equals(this.proxyId) && ref.proxyFile.equals((Object)this.proxyFile);
        }
        return false;
    }

    public int hashCode() {
        return this.proxyFile.hashCode();
    }
}

