/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.IReferenceRegistrySavedState;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ProjectReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.util.TestCaseInvocationDeleter;

public class ReferenceRegistry
implements ISaveParticipant {
    private static ReferenceRegistry instance;
    private Map projectRegistries = new HashMap();
    private IReferenceRegistrySavedState internalSavedState;

    public static ReferenceRegistry getInstance() {
        if (instance == null) {
            instance = new ReferenceRegistry();
        }
        return instance;
    }

    private ReferenceRegistry() {
        try {
            ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)UiPlugin.getDefault(), (ISaveParticipant)this);
            this.internalSavedState = lastState != null ? new SavedState(lastState) : null;
        }
        catch (CoreException coreException) {}
        TestCaseInvocationDeleter.getInstance();
    }

    private ProjectReferenceRegistry getRegistry(IFile referencer) {
        IProject project = referencer.getProject();
        if (project.isAccessible()) {
            return this.getProjectReferenceRegistry(project);
        }
        return null;
    }

    public ProjectReferenceRegistry getProjectReferenceRegistry(IProject project) {
        ProjectReferenceRegistry registry = (ProjectReferenceRegistry)this.projectRegistries.get(project);
        if (registry == null) {
            registry = new ProjectReferenceRegistry(project, this.internalSavedState);
            this.projectRegistries.put(project, registry);
        }
        return registry;
    }

    public void removeProjectReferenceRegistry(IProject project) {
        this.projectRegistries.remove(project);
    }

    public void addReference(IFile referencer, String refType, IFile referenced) {
        ProjectReferenceRegistry registry = this.getRegistry(referencer);
        if (registry != null) {
            registry.addReference(referencer, refType, referenced);
        }
    }

    public void addBidirectionalReference(IFile referencer, String refType, IFile referenced, String oppositeRefType) {
        ProjectReferenceRegistry registryReferencer = this.getRegistry(referencer);
        ProjectReferenceRegistry registryReferenced = this.getRegistry(referenced);
        if (registryReferencer != null) {
            registryReferencer.addReference(referencer, refType, referenced);
        }
        if (registryReferenced != null) {
            registryReferenced.addReference(referenced, oppositeRefType, referencer);
        }
    }

    public void removeReference(IFile referencer, IFile referenced) {
        ProjectReferenceRegistry registry = this.getRegistry(referencer);
        if (registry != null) {
            registry.removeReference(referencer, referenced);
        }
    }

    public Collection getReferences(IFile referencer, String refType) {
        ProjectReferenceRegistry registry = this.getRegistry(referencer);
        if (registry != null) {
            return registry.getReferences(referencer, refType);
        }
        return Collections.EMPTY_LIST;
    }

    public Set getReferenceTypes(IFile referencer) {
        ProjectReferenceRegistry registry = this.getRegistry(referencer);
        if (registry != null) {
            return registry.getReferenceTypes(referencer);
        }
        return Collections.EMPTY_SET;
    }

    public void doneSaving(ISaveContext context) {
        if (context.getKind() == 3) {
            IProject project = context.getProject();
            ProjectReferenceRegistry registry = (ProjectReferenceRegistry)this.projectRegistries.get(project);
            if (registry != null) {
                registry.doneSaving(context);
            }
        } else {
            for (ProjectReferenceRegistry registry : this.projectRegistries.values()) {
                registry.doneSaving(context);
            }
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        if (context.getKind() == 3) {
            IProject project = context.getProject();
            ProjectReferenceRegistry registry = (ProjectReferenceRegistry)this.projectRegistries.get(project);
            if (registry != null) {
                registry.prepareToSave(context);
            }
        } else {
            for (ProjectReferenceRegistry registry : this.projectRegistries.values()) {
                registry.prepareToSave(context);
            }
        }
    }

    public void rollback(ISaveContext context) {
        if (context.getKind() == 3) {
            IProject project = context.getProject();
            ProjectReferenceRegistry registry = (ProjectReferenceRegistry)this.projectRegistries.get(project);
            if (registry != null) {
                registry.rollback(context);
            }
        } else {
            for (ProjectReferenceRegistry registry : this.projectRegistries.values()) {
                registry.rollback(context);
            }
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        if (context.getKind() == 3) {
            IProject project = context.getProject();
            ProjectReferenceRegistry registry = (ProjectReferenceRegistry)this.projectRegistries.get(project);
            if (registry != null) {
                registry.saving(context);
            }
        } else {
            for (ProjectReferenceRegistry registry : this.projectRegistries.values()) {
                registry.saving(context);
            }
        }
    }

    public void removeReferences(IFile referencer) {
        ProjectReferenceRegistry registry = this.getRegistry(referencer);
        if (registry != null) {
            registry.removeReferences(referencer);
        }
    }

    private class SavedState
    implements IReferenceRegistrySavedState {
        private ISavedState savedState;

        public SavedState(ISavedState state) {
            this.savedState = state;
        }

        public IPath lookup(IPath path) {
            return this.savedState.lookup(path);
        }
    }
}

