/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.TrashBox;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class DeleteContainerChange
extends ReorgContainerChange {
    private boolean physicalDelete = false;
    private boolean isProject = false;
    private List associationList;

    public DeleteContainerChange(IContainer cont, boolean physicalDelete, List associationList) {
        super(cont);
        this.isProject = cont instanceof IProject;
        this.physicalDelete = physicalDelete;
        if (!this.isProject) {
            this.setEnabled(physicalDelete);
        }
        this.associationList = associationList;
        this.updateAssociationMapping((IResource)cont);
    }

    public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
        Change undo = null;
        try {
            if (container instanceof IProject) {
                TrashBox.instance().trashProject((IProject)container, this.physicalDelete);
            } else {
                TrashBox.instance().trashResource((IResource)container);
            }
            undo = TrashBox.instance().createUntrashChange((IResource)container);
        }
        catch (Exception e) {
            UiPlugin.logError("error while putting container into trashbox : " + container.getName());
            UiPlugin.logError(e);
        }
        if (this.associationList != null) {
            for (Change proxChange : this.associationList) {
                if (proxChange.isEnabled()) continue;
                return undo;
            }
        }
        try {
            if (container instanceof IProject) {
                ((IProject)container).delete(this.physicalDelete, true, (IProgressMonitor)monitor);
            } else {
                container.delete(true, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
        return undo;
    }

    public String getName() {
        if (this.isProject) {
            return NLS.bind((String)RefactoringMessages.DELETE_PROJECT, (Object)this.getPath().toString());
        }
        return NLS.bind((String)RefactoringMessages.DELETE_FOLDER, (Object)this.getPath().toString());
    }
}

