/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.TrashBox;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteLogicalProjectChange
extends Change {
    private IProject project;

    public DeleteLogicalProjectChange(IProject project) {
        this.project = project;
    }

    public Object getModifiedElement() {
        return this.project;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.REMOVE_PROJECT, (Object)this.project.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.project.isAccessible()) {
            if (this.project.exists()) {
                status.addWarning(RefactoringMessages.NOT_OPEN_PROJECT);
            } else {
                status.addFatalError(RefactoringMessages.NOT_EXIST_PROJECT);
            }
        } else {
            ResourceAttributes resAtt = this.project.getResourceAttributes();
            if (resAtt == null) {
                status.addError(RefactoringMessages.ERROR);
            } else if (resAtt.isReadOnly()) {
                status.addWarning(RefactoringMessages.READ_ONLY_PROJECT);
            }
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change undo = null;
        try {
            try {
                TrashBox.instance().trashProject(this.project, false);
            }
            catch (Exception e) {
                UiPlugin.logError("error while putting project into trashbox : " + this.project.getName());
                UiPlugin.logError(e);
            }
            try {
                undo = TrashBox.instance().createUntrashChange((IResource)this.project);
            }
            catch (Exception e) {
                UiPlugin.logError("error while creating undo delete for project : " + this.project.getName());
                UiPlugin.logError(e);
            }
            this.project.delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
        return undo;
    }
}

