/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteModelElementChange
extends Change {
    private IProxyNode proxy;
    protected EMFRefactoringTransaction context;
    private Change fileChange;

    public DeleteModelElementChange(IRefactoringContext context, EObjectProxyNode node) {
        this.proxy = node;
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        Object file = node.getAdapter(IFile.class);
        this.fileChange = file != null ? new DeleteFileChange((IFile)file) : new NullChange(NLS.bind((String)RefactoringMessages.UPDATE_PROXY, (Object)this.proxy.getUnderlyingResource().getFullPath().toPortableString()));
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return this.fileChange.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fileChange.isValid(pm);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileChange.setEnabled(enabled);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        URI uri = ((EObjectProxyNode)this.proxy).getOriginatorURI();
        Resource res = this.context.getResourceSet().getResource(uri.trimFragment(), true);
        EObject eObject = res.getEObject(uri.fragment());
        if (eObject != null) {
            EMFUtil.remove((EObject)eObject);
        }
        if (!(this.fileChange instanceof NullChange)) {
            return this.fileChange.perform(pm);
        }
        this.context.addSavedResource(res);
        return null;
    }
}

