/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteTestInvocationChange
extends Change {
    private EMFRefactoringTransaction context;
    private IProxyNode invokee;
    private DefaultTestSuiteProxyNode test;

    public DeleteTestInvocationChange(IRefactoringContext context, DefaultTestSuiteProxyNode node, IReferencerProxyNode referenced) {
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        Assert.isNotNull((Object)this.context);
        this.test = node;
        this.invokee = (IProxyNode)referenced.getAdapter(IProxyNode.class);
    }

    public Object getModifiedElement() {
        return this.test;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.DELETE_INVOCATION, (Object)this.invokee.getText(), (Object)this.test.getText());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    private void removeTestInvocation(IBlock block, URI invokeeURI) {
        if (block != null) {
            List actions = block.getActions();
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                EObject parent;
                Object action = it.next();
                if (action instanceof ILoop) {
                    this.removeTestInvocation(((ILoop)action).getBlock(), invokeeURI);
                    continue;
                }
                if (action instanceof IDecision) {
                    IDecision ifAction = (IDecision)action;
                    this.removeTestInvocation(ifAction.getFailureBlock(), invokeeURI);
                    this.removeTestInvocation(ifAction.getSuccessBlock(), invokeeURI);
                    continue;
                }
                if (!(action instanceof ITestInvocation)) continue;
                ITestInvocation invocationAction = (ITestInvocation)action;
                TPFTest invokedTest = (TPFTest)invocationAction.getInvokedTest();
                if (EcoreUtil.getURI((EObject)invokedTest).equals((Object)invokeeURI)) {
                    it.remove();
                    continue;
                }
                if (invokedTest instanceof ITestCase && (parent = invokedTest.eContainer()) instanceof TPFTest) {
                    invokedTest = (TPFTest)parent;
                }
                if (!EcoreUtil.getURI((EObject)invokedTest).equals((Object)invokeeURI)) continue;
                it.remove();
            }
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.invokee instanceof EObjectProxyNode) {
            URI invokeeURI = ((EObjectProxyNode)this.invokee).getOriginatorURI();
            Resource res = this.context.getResourceSet().getResource(this.test.getOriginatorURI().trimFragment(), true);
            TPFTestSuite testObject = (TPFTestSuite)res.getEObject(this.test.getOriginatorURI().fragment());
            this.removeTestInvocation(testObject.getImplementor().getBlock(), invokeeURI);
            this.context.addSavedResource(res);
        }
        return null;
    }
}

