/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class MoveFileChange
extends Change {
    private IFile file;
    private IContainer destFolder;

    public MoveFileChange(IFile file, IContainer destination) {
        this.file = file;
        this.destFolder = destination;
    }

    public Object getModifiedElement() {
        return this.file;
    }

    public String getName() {
        IPath path = this.file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
        return NLS.bind((String)RefactoringMessages.MOVE_FILE, (Object)path.toString(), (Object)this.destFolder.getFullPath().toString());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IFile destFile = this.destFolder.getFile((IPath)new Path(this.file.getName()));
        if (!this.file.exists()) {
            status.addError(RefactoringMessages.NO_FILE);
        }
        if (destFile.exists()) {
            status.addWarning(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_FILE, (Object)destFile.getFullPath().toPortableString()));
        }
        if (this.file.isReadOnly()) {
            status.addWarning(RefactoringMessages.READ_ONLY_FILE);
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        MoveFileChange undo = null;
        pm.beginTask("", 1);
        try {
            IPath targetPath = this.destFolder.getFullPath().append(this.file.getName());
            IContainer parent = this.file.getParent();
            if (parent != null) {
                undo = new MoveFileChange(ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath), parent);
            }
            this.file.move(targetPath, false, true, pm);
            pm.worked(1);
            MoveFileChange moveFileChange = undo;
            return moveFileChange;
        }
        finally {
            pm.done();
        }
    }
}

