/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class MoveFolderChange
extends ReorgContainerChange {
    protected IPath destPath;

    public MoveFolderChange(IFolder folder, IPath destPath) {
        super((IContainer)folder);
        this.destPath = destPath;
    }

    public IPath getDestinationPath() {
        return this.destPath;
    }

    public String getName() {
        IPath path = this.getPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
        return NLS.bind((String)RefactoringMessages.MOVE_FOLDER, (Object)path.toString(), (Object)this.destPath.toString());
    }

    public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
        MoveFolderChange undo = null;
        try {
            IPath targetPath = this.destPath.append(container.getName());
            IContainer parent = container.getParent();
            if (parent != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                Object dest = this.destPath.segmentCount() == 1 ? root.getProject(this.destPath.toOSString()) : root.getFolder(this.destPath);
                IFolder folder = dest.getFolder((IPath)new Path(container.getName()));
                undo = new MoveFolderChange(folder, parent.getFullPath());
            }
            container.move(targetPath, false, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            UiPlugin.logError("Unable to move container", e);
        }
        TestUIUtilities.recursiveRefreshProxy((IResource)ResourcesPlugin.getWorkspace().getRoot().getFolder(this.destPath.append(container.getName())));
        return undo;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IFolder folder = (IFolder)this.getModifiedElement();
        if (!folder.isAccessible()) {
            status.addFatalError(RefactoringMessages.NO_FOLDER);
        }
        return super.isValid(pm);
    }
}

