/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class MoveModelChange
extends Change {
    private EMFRefactoringTransaction context;
    protected IPath destination;
    protected EObjectProxyNode proxy;
    private boolean shouldBeRenamed;
    private RefactoringStatus status;
    private IRefactoringContext globalContext;

    public MoveModelChange(EObjectProxyNode node, IRefactoringContext context, IPath destinationPath) {
        this.proxy = node;
        this.globalContext = context;
        this.destination = destinationPath;
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        Assert.isNotNull((Object)this.context);
        this.status = new RefactoringStatus();
        IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.destination);
        if (destFile.exists()) {
            this.handleFileAlreadyExists(this.status);
        }
    }

    public Object getModifiedElement() {
        return this.proxy;
    }

    public String getName() {
        String fileName = this.proxy.getUnderlyingResource().getFullPath().toString();
        return NLS.bind((String)RefactoringMessages.MOVE_FILE, (Object)fileName, (Object)this.destination.removeLastSegments(1));
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.status;
    }

    protected void handleFileAlreadyExists(RefactoringStatus status) {
        status.addInfo(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_PROXY_DURING_MOVE, (Object)this.destination.toPortableString()));
        this.shouldBeRenamed = true;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        MoveModelChange undo = null;
        Resource res = this.context.getResourceSet().getResource(this.proxy.getOriginatorURI().trimFragment(), true);
        this.context.addSavedResource(res);
        this.context.addChangedResourceURI(res, this.getNewURI());
        Path originalPath = new Path(this.proxy.getOriginatorURI().devicePath());
        undo = new MoveModelChange(this.proxy, this.globalContext, (IPath)originalPath);
        return undo;
    }

    public URI getNewURI() {
        return URI.createPlatformResourceURI((String)this.getNewName(), (boolean)false);
    }

    private String getNewName() {
        if (this.shouldBeRenamed) {
            String fullFileName = this.destination.lastSegment();
            int dotIndex = fullFileName.lastIndexOf(46);
            long number = new Date().getTime();
            String newName = String.valueOf(fullFileName.substring(0, dotIndex - 1)) + number + fullFileName.substring(dotIndex);
            return this.destination.removeLastSegments(1).append(newName).toPortableString();
        }
        return this.destination.toPortableString();
    }
}

