/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.CompositeReferencerProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CompositeListenerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CustomRefactoringManager;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveFolderCompositeChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringTransactionRootChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeUpdater;
import org.eclipse.hyades.test.ui.navigator.refactoring.MoveRefactoringEvent;
import org.eclipse.hyades.test.ui.navigator.refactoring.UpdateRefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.osgi.util.NLS;

public class MoveRefactoring
extends ReorgRefactoring {
    private List folders;
    private List proxies;
    private IContainer destination;

    public MoveRefactoring(List folders, List proxies) {
        this.folders = folders;
        this.proxies = proxies;
    }

    public List getContainers() {
        return this.folders;
    }

    public List getProxies() {
        return this.proxies;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.change != null) {
            return this.change;
        }
        pm.beginTask("", this.folders.size() + this.proxies.size());
        try {
            RefactoringTransactionRootChange c = new RefactoringTransactionRootChange(this.context);
            CustomRefactoringManager.addAllStartingChange(c, 1);
            for (IFolder folder : this.folders) {
                Change containerChange = this.createMoveContainerChange(folder, this.destination);
                if (containerChange != null) {
                    c.add(containerChange);
                }
                pm.worked(1);
            }
            for (IProxyNode proxy : this.proxies) {
                Change refChange = this.createMoveProxyChange(proxy, this.destination);
                if (refChange != null) {
                    c.add(refChange);
                }
                pm.worked(1);
            }
            CustomRefactoringManager.addAllEndingChange(c, 1);
            c.markAsSynthetic();
            RefactoringTransactionRootChange refactoringTransactionRootChange = c;
            return refactoringTransactionRootChange;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return "";
    }

    public void setDestination(IContainer container) {
        this.destination = container;
        this.change = null;
        this.seenElements.clear();
    }

    protected Change createMoveProxyChange(IProxyNode node, IContainer dest) {
        if (!this.seenElements.contains(node)) {
            this.seenElements.add(node);
            if (node instanceof IReferencerProxyNode) {
                return this.createMoveReferencerChange(node, dest);
            }
            return this.createShallowMoveProxyChange(node, dest);
        }
        return null;
    }

    private Change createShallowMoveProxyChange(IProxyNode node, IContainer dest) {
        MoveFileChange mainChange;
        IFile file = (IFile)node.getAdapter(IFile.class);
        IProxyNodeMover mover = (IProxyNodeMover)node.getAdapter(IProxyNodeMover.class);
        if (mover != null) {
            String fileName = file == null ? node.getUnderlyingResource().getName() : file.getName();
            mainChange = mover.createMoveChange(this.context, dest.getFullPath().append(fileName));
        } else if (file != null) {
            mainChange = new MoveFileChange(file, dest);
        } else {
            return new NullChange(NLS.bind((String)RefactoringMessages.UPDATE_PROXY, (Object)node.getUnderlyingResource().getFullPath().toPortableString()));
        }
        MoveRefactoringEvent event = new MoveRefactoringEvent(node, this.destination);
        CompositeListenerChange compositeListener = new CompositeListenerChange(event);
        compositeListener.add(mainChange);
        return compositeListener;
    }

    private Change createMoveReferencerChange(IProxyNode node, IContainer dest) {
        CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.MOVE_PROXY, (Object)node.getText(), (Object)dest.getName()));
        Change moveNode = this.createShallowMoveProxyChange(node, dest);
        CompositeReferencerProxyNode ref = new CompositeReferencerProxyNode(node);
        for (String type : ref.getReferenceTypes()) {
            String oppType = ReferenceTypeRegistry.getInstance().getOppositeReferenceType(type);
            if (!ReferenceTypeRegistry.getInstance().isExplicit(oppType)) continue;
            composite.add(this.createUpdateReferenceTypeChange(ref, type, dest));
        }
        if (moveNode != null) {
            composite.add(moveNode);
        }
        return composite;
    }

    private Change createUpdateReferenceTypeChange(CompositeReferencerProxyNode ref, String type, IContainer dest) {
        CompositeChange change = new CompositeChange(ReferenceTypeRegistry.getInstance().getName(type));
        for (IProxyNode proxy : ref.getReferences(type)) {
            IProxyNodeUpdater updater = (IProxyNodeUpdater)proxy.getAdapter(IProxyNodeUpdater.class);
            if (updater == null) continue;
            IPath destPath = dest.getFullPath().append(ref.getUnderlyingResource().getName());
            UpdateRefactoringEvent event = new UpdateRefactoringEvent(proxy, ref, type, destPath);
            CompositeListenerChange composite = new CompositeListenerChange(event);
            composite.add(updater.createUpdateChange(this.context, ref, type, destPath));
            change.add((Change)composite);
        }
        return change;
    }

    private Change createMoveContainerChange(IFolder folder, IContainer dest) {
        MoveRefactoringEvent event = new MoveRefactoringEvent(folder, this.destination);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        MoveFolderCompositeChange change = new MoveFolderCompositeChange(folder, dest.getFullPath());
        this.performContainerChildren(change, (IContainer)folder, dest.getFullPath().append(folder.getName()));
        change.freeze();
        composite.add((Change)change);
        return composite;
    }
}

