/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.MoveRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MoveRefactoringWizard
extends RefactoringWizard {
    public MoveRefactoringWizard(Refactoring refactoring) {
        super(refactoring, 4);
    }

    protected void addUserInputPages() {
        MoveRefactoringInputPage page = new MoveRefactoringInputPage(this.getRefactoring());
        this.addPage((IWizardPage)page);
    }

    private static class MoveRefactoringInputPage
    extends UserInputWizardPage {
        private MoveRefactoring refactoring;
        private TreeViewer viewer;
        private List allParents = null;

        public MoveRefactoringInputPage(Refactoring ref) {
            super("");
            this.refactoring = (MoveRefactoring)ref;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            result.setLayout((Layout)new GridLayout());
            this.addLabel(result);
            this.viewer = this.createViewer(result);
            this.expandSelectionContainer();
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MoveRefactoringInputPage.this.viewerSelectionChanged(event);
                }
            });
            Dialog.applyDialogFont((Control)result);
        }

        private void expandSelectionContainer() {
            List containers = this.refactoring.getContainers();
            List proxies = this.refactoring.getProxies();
            HashSet<IContainer> parents = new HashSet<IContainer>();
            Iterator it = containers.iterator();
            while (it.hasNext()) {
                parents.add(((IContainer)it.next()).getParent());
            }
            it = proxies.iterator();
            while (it.hasNext()) {
                parents.add(((IProxyNode)it.next()).getUnderlyingResource().getParent());
            }
            it = parents.iterator();
            while (it.hasNext()) {
                this.viewer.expandToLevel(it.next(), 0);
            }
        }

        protected Control addLabel(Composite parent) {
            Label label = new Label(parent, 0);
            int containers = this.refactoring.getContainers().size();
            int proxies = this.refactoring.getProxies().size();
            String text = containers == 0 && proxies == 1 ? NLS.bind((String)RefactoringMessages.MOVE_CHOOSE_DESTINATION_SINGLE, (Object)((IProxyNode)this.refactoring.getProxies().get(0)).getText()) : (containers == 1 && proxies == 0 ? NLS.bind((String)RefactoringMessages.MOVE_CHOOSE_DESTINATION_SINGLE, (Object)((IResource)this.refactoring.getContainers().get(0)).getName()) : NLS.bind((String)RefactoringMessages.MOVE_CHOOSE_DESTINATION_MULTI, (Object)String.valueOf(containers + proxies)));
            label.setText(text);
            label.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
            this.buildParentList();
            return label;
        }

        private void buildParentList() {
            this.allParents = new ArrayList();
            Iterator it = this.refactoring.getContainers().iterator();
            while (it.hasNext()) {
                this.allParents.add(((IResource)it.next()).getParent());
            }
            it = this.refactoring.getProxies().iterator();
            while (it.hasNext()) {
                IContainer parent = ((IProxyNode)it.next()).getUnderlyingResource().getParent();
                if (!(parent instanceof IContainer)) continue;
                this.allParents.add(parent);
            }
        }

        private TreeViewer createViewer(Composite parent) {
            TreeViewer treeViewer = new TreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            treeViewer.getTree().setLayoutData((Object)gd);
            BaseWorkbenchContentProvider provider = new BaseWorkbenchContentProvider(){

                public Object[] getChildren(Object element) {
                    Object[] children = super.getChildren(element);
                    LinkedList<Object> resChildren = new LinkedList<Object>();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IContainer && ((IContainer)children[i]).isAccessible() && !TestNavigator.getFiltersManager().filter(children[i])) {
                            resChildren.add(children[i]);
                        }
                        ++i;
                    }
                    return resChildren.toArray();
                }
            };
            treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            treeViewer.setContentProvider((IContentProvider)provider);
            treeViewer.setSorter(null);
            treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            return treeViewer;
        }

        private void viewerSelectionChanged(SelectionChangedEvent event) {
            if (this.isPageComplete()) {
                this.refactoring.setDestination((IContainer)((IStructuredSelection)event.getSelection()).getFirstElement());
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }

        public boolean isPageComplete() {
            ISelection selection = this.viewer.getSelection();
            if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.MISSING_CONTAINER);
                return false;
            }
            Object selectedContainer = ((IStructuredSelection)selection).getFirstElement();
            if (selectedContainer == null || !(selectedContainer instanceof IContainer)) {
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.MISSING_CONTAINER);
                return false;
            }
            IContainer container = (IContainer)selectedContainer;
            if (this.allParents != null) {
                for (IContainer parent : this.allParents) {
                    if (!container.equals((Object)parent)) continue;
                    this.setMessage(null);
                    this.setErrorMessage(RefactoringMessages.DUPLICATE_NAME);
                    return false;
                }
            }
            Iterator refactoringContainersIterator = this.refactoring.getContainers().iterator();
            while (refactoringContainersIterator.hasNext()) {
                String refactoringContainerName = ((IContainer)refactoringContainersIterator.next()).getName();
                if (!TestUIUtil.isResourcePathLengthValid(refactoringContainerName, container)) {
                    this.setMessage(null);
                    this.setErrorMessage(RefactoringMessages.LONG_NAME);
                    return false;
                }
                if (TestUIUtil.isResourcePathAvailable(refactoringContainerName, container)) continue;
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.DUPLICATE_NAME);
                return false;
            }
            Iterator refactoringProxiesIterator = this.refactoring.getProxies().iterator();
            while (refactoringProxiesIterator.hasNext()) {
                String refactoringProxiesName = ((IProxyNode)refactoringProxiesIterator.next()).getUnderlyingResource().getName();
                if (!TestUIUtil.isResourcePathLengthValid(refactoringProxiesName, container)) {
                    this.setMessage(null);
                    this.setErrorMessage(RefactoringMessages.LONG_NAME);
                    return false;
                }
                if (TestUIUtil.isResourcePathAvailable(refactoringProxiesName, container)) continue;
                this.setMessage(null);
                this.setErrorMessage(RefactoringMessages.DUPLICATE_NAME);
                return false;
            }
            this.setMessage(null);
            this.setErrorMessage(null);
            return true;
        }
    }
}

