/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.DeleteContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.refactoring.AbstractPasteChange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class PasteContainerChange
extends AbstractPasteChange {
    private String externalFileName;
    private IContainer destination;
    private String externalBaseName;
    private String destName;

    public PasteContainerChange(String externalFileName, IContainer destination) {
        this.externalFileName = externalFileName;
        this.destination = destination;
        this.externalBaseName = new Path(externalFileName).lastSegment();
        this.destName = PasteFileChange.buildNewName(destination.getFullPath().append(this.externalBaseName));
    }

    public Object getModifiedElement() {
        return this.externalFileName;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.PASTE_FOLDER, (Object)this.externalBaseName, (Object)this.destName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        File tmp = new File(this.externalFileName);
        if (!tmp.exists()) {
            status.addError(RefactoringMessages.NO_FOLDER);
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        DeleteContainerChange undo = null;
        pm.beginTask("", 1);
        File file = new File(this.externalFileName);
        try {
            File destFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.destName).toFile();
            if (file.exists()) {
                this.recursiveCopy(file, destFile, this.destination);
                undo = new DeleteContainerChange((IContainer)this.destination.getFolder((IPath)new Path(new Path(this.destName).lastSegment())), true, null);
            }
            pm.worked(1);
            DeleteContainerChange deleteContainerChange = undo;
            return deleteContainerChange;
        }
        catch (IOException e) {
            UiPlugin.logError(RefactoringMessages.IO_ERROR_PASTING_FILE);
            new ErrorDialog(Display.getDefault().getActiveShell(), RefactoringMessages.ERROR, NLS.bind((String)RefactoringMessages.IO_ERROR_PASTING_FILE, (Object)file.getName()), (IStatus)new Status(4, "org.eclipse.hyades.test.ui", 0, e.toString(), (Throwable)e), 4).open();
            DeleteContainerChange deleteContainerChange = undo;
            return deleteContainerChange;
        }
        finally {
            pm.done();
        }
    }

    private void recursiveCopy(File source, File dest, IContainer destfolder) throws IOException, CoreException {
        if (source.isDirectory()) {
            IFolder folder = destfolder.getFolder((IPath)new Path(dest.getName()));
            if (!dest.exists()) {
                dest.mkdirs();
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            String[] files = source.list();
            int i = 0;
            while (i < files.length) {
                this.recursiveCopy(new File(source, files[i]), new File(dest, files[i]), (IContainer)folder);
                ++i;
            }
        } else {
            if (!source.exists()) {
                return;
            }
            IFile file = destfolder.getFile((IPath)new Path(dest.getName()));
            FileInputStream in = new FileInputStream(source);
            if (file.exists()) {
                file.setContents((InputStream)in, true, false, null);
            } else {
                file.create((InputStream)in, true, null);
            }
            ((InputStream)in).close();
        }
    }

    public String getNewName() {
        return this.destName;
    }
}

