/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.PasteFolderChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PasteFolderCompositeChange
extends CompositeChange {
    private IFolder folder;
    private PasteFolderChange root;

    public PasteFolderCompositeChange(IFolder folder, IPath newPath, IPath[] targetPath) {
        super("");
        this.folder = folder;
        this.root = new PasteFolderChange(folder, newPath, targetPath);
    }

    public Object getModifiedElement() {
        return this.folder;
    }

    public String getName() {
        return this.root.getName();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = this.root.isValid(pm);
        if (this.folder.getFullPath().isPrefixOf(this.root.getDestinationPath())) {
            status.addFatalError(RefactoringMessages.INNER_FOLDER_PASTE_ERROR);
        }
        status.merge(super.isValid(pm));
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.getChildren().length + 1);
        try {
            CompositeChange undo = new CompositeChange("paste undo");
            undo.add(this.root.perform((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            undo.add(super.perform((IProgressMonitor)new SubProgressMonitor(pm, this.getChildren().length)));
            CompositeChange compositeChange = undo;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    public void freeze() {
        if (this.getChildren().length == 0) {
            this.markAsSynthetic();
            this.add((Change)new NullChange(this.getName()));
        }
    }
}

