/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.IRefactoringTransaction;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class RefactoringContext
implements IRefactoringTransaction,
IRefactoringContext {
    private static Map knownTransactions = new HashMap();
    private Map transactions = new LinkedHashMap();

    public void beginChanges(IProgressMonitor pm) {
        pm.beginTask("", this.transactions.values().size());
        try {
            for (IRefactoringTransaction transaction : this.transactions.values()) {
                transaction.beginChanges((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    public void cancelChanges(IProgressMonitor pm) {
        pm.beginTask("", this.transactions.values().size());
        try {
            for (IRefactoringTransaction transaction : this.transactions.values()) {
                transaction.cancelChanges((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    public Change commitChanges(IProgressMonitor pm) throws CoreException {
        CompositeChange c = new CompositeChange("");
        pm.beginTask("", this.transactions.values().size());
        try {
            for (IRefactoringTransaction transaction : this.transactions.values()) {
                c.add(transaction.commitChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            CompositeChange compositeChange = c;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    public IRefactoringTransaction getRefactoringTransaction(String domainId) {
        IRefactoringTransaction t = (IRefactoringTransaction)this.transactions.get(domainId);
        if (t != null) {
            return t;
        }
        try {
            t = RefactoringContext.internalGetRefactoringTransaction(domainId);
            if (t != null) {
                this.transactions.put(domainId, t);
                return t;
            }
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
        return null;
    }

    private static IRefactoringTransaction internalGetRefactoringTransaction(String domainId) throws CoreException {
        IExtensionPoint extPoint;
        IConfigurationElement e = (IConfigurationElement)knownTransactions.get(domainId);
        if (e == null && (extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorRefactoringTransactions")) != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                String id;
                IConfigurationElement element = members[i];
                if ("transaction".equals(element.getName()) && (id = element.getAttribute("domainId")) != null) {
                    knownTransactions.put(id, element);
                }
                ++i;
            }
            e = (IConfigurationElement)knownTransactions.get(domainId);
        }
        if (e == null) {
            UiPlugin.logError("Unable to find a registered refactoring transaction with the domain Id: '" + domainId + '\'');
            return null;
        }
        return (IRefactoringTransaction)e.createExecutableExtension("class");
    }
}

