/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameFileChange
extends Change {
    private IFile file;
    private String name;

    public RenameFileChange(IFile file, String name) {
        this.file = file;
        this.name = name;
    }

    public Object getModifiedElement() {
        return this.file;
    }

    public String getName() {
        String newPathName = this.file.getParent().getFullPath().append((IPath)new Path(this.name)).toString();
        IPath path = this.file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
        return NLS.bind((String)RefactoringMessages.RENAME_FILE, (Object)path.toString(), (Object)newPathName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IFile destFile = this.file.getParent().getFile((IPath)new Path(this.name));
        if (!this.file.exists()) {
            status.addError(RefactoringMessages.NO_FILE);
        }
        if (this.file.isReadOnly()) {
            status.addWarning(RefactoringMessages.READ_ONLY_FILE);
        }
        if (destFile.exists()) {
            status.addWarning(NLS.bind((String)RefactoringMessages.ALREADY_EXISTS_FILE, (Object)destFile.getFullPath().toPortableString()));
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        RenameFileChange undo = null;
        try {
            pm.beginTask("", 1);
            IContainer parent = this.file.getParent();
            String originalName = this.file.getName();
            IPath newPath = parent.getFullPath().append((IPath)new Path(this.name));
            undo = new RenameFileChange(parent.getFile((IPath)new Path(this.name)), originalName);
            this.file.move(newPath, false, true, pm);
            pm.worked(1);
            RenameFileChange renameFileChange = undo;
            return renameFileChange;
        }
        finally {
            pm.done();
        }
    }
}

