/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.CompositeReferencerProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CompositeListenerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CustomRefactoringManager;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringTransactionRootChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RenameContainerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RenameFileChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.ReorgRefactoring;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer2;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeUpdater;
import org.eclipse.hyades.test.ui.navigator.refactoring.RenameRefactoringEvent;
import org.eclipse.hyades.test.ui.navigator.refactoring.UpdateRefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.osgi.util.NLS;

public class RenameRefactoring
extends ReorgRefactoring {
    private IProxyNode proxy;
    private IContainer container;
    private String name;

    public RenameRefactoring(IProxyNode node) {
        this.proxy = node;
    }

    public RenameRefactoring(IContainer cont) {
        this.container = cont;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.change != null) {
            return this.change;
        }
        try {
            pm.beginTask("", 1);
            RefactoringTransactionRootChange c = new RefactoringTransactionRootChange(this.context);
            CustomRefactoringManager.addAllStartingChange(c, 2);
            if (this.container != null) {
                Change containerChange = this.createRenameContainerChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (containerChange != null) {
                    c.add(containerChange);
                }
            } else if (this.proxy != null) {
                Change proxyChange = this.createRenameProxyNodeChange();
                if (proxyChange != null) {
                    c.add(proxyChange);
                }
                pm.worked(1);
            }
            CustomRefactoringManager.addAllEndingChange(c, 2);
            c.markAsSynthetic();
            RefactoringTransactionRootChange refactoringTransactionRootChange = c;
            return refactoringTransactionRootChange;
        }
        finally {
            pm.done();
        }
    }

    private Change createRenameProxyNodeChange() {
        if (!this.seenElements.contains(this.proxy)) {
            this.seenElements.add(this.proxy);
            if (this.proxy instanceof IReferencerProxyNode) {
                return this.createRenameModelChange();
            }
            return this.createShallowRenameProxyChange();
        }
        return null;
    }

    private Change createShallowRenameProxyChange() {
        Change mainChange;
        IProxyNodeRenamer2 renamer = (IProxyNodeRenamer2)this.proxy.getAdapter(IProxyNodeRenamer2.class);
        if (renamer != null) {
            mainChange = renamer.createRenameChange(this.context, this.name);
        } else {
            IResource res;
            IFile file = (IFile)this.proxy.getAdapter(IFile.class);
            if (file == null && (res = this.proxy.getUnderlyingResource()) instanceof IFile) {
                file = (IFile)res;
            }
            if (file != null) {
                mainChange = new RenameFileChange(file, this.name);
            } else {
                return new NullChange(NLS.bind((String)RefactoringMessages.UPDATE_PROXY, (Object)this.proxy.getUnderlyingResource().getFullPath().toPortableString()));
            }
        }
        RenameRefactoringEvent event = new RenameRefactoringEvent(this.proxy, this.name);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        composite.add(mainChange);
        return composite;
    }

    private Change createRenameModelChange() {
        CompositeChange composite = new CompositeChange("");
        Change renameNode = this.createShallowRenameProxyChange();
        if (renameNode != null) {
            composite.add(renameNode);
        }
        CompositeReferencerProxyNode ref = new CompositeReferencerProxyNode(this.proxy);
        for (String type : ref.getReferenceTypes()) {
            String oppType = ReferenceTypeRegistry.getInstance().getOppositeReferenceType(type);
            if (!ReferenceTypeRegistry.getInstance().isExplicit(oppType)) continue;
            composite.add(this.createUpdateReferenceTypeChange(ref, type));
        }
        composite.markAsSynthetic();
        return composite;
    }

    private Change createUpdateReferenceTypeChange(CompositeReferencerProxyNode ref, String type) {
        CompositeChange change = new CompositeChange(ReferenceTypeRegistry.getInstance().getName(type));
        for (IProxyNode localproxy : ref.getReferences(type)) {
            IProxyNodeUpdater updater = (IProxyNodeUpdater)localproxy.getAdapter(IProxyNodeUpdater.class);
            if (updater == null) continue;
            IPath oldPath = ref.getUnderlyingResource().getFullPath();
            IPath destPath = oldPath.removeLastSegments(1).append((IPath)new Path(String.valueOf(this.name) + '.' + oldPath.getFileExtension()));
            UpdateRefactoringEvent event = new UpdateRefactoringEvent(this.proxy, ref, type, destPath);
            CompositeListenerChange composite = new CompositeListenerChange(event);
            composite.add(updater.createUpdateChange(this.context, ref, type, destPath));
            change.add((Change)composite);
        }
        return change;
    }

    private Change createRenameContainerChange(IProgressMonitor pm) {
        RenameRefactoringEvent event = new RenameRefactoringEvent(this.container, this.name);
        CompositeListenerChange composite = new CompositeListenerChange(event);
        RenameContainerChange change = new RenameContainerChange(this.container, this.name);
        this.performContainerChildren(change, this.container, this.container.getFullPath().removeLastSegments(1).append(this.name));
        change.freeze();
        composite.add((Change)change);
        return composite;
    }

    public void setNewName(String text) {
        this.name = text;
        this.change = null;
        this.seenElements.clear();
    }
}

