/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.CompositeReferencerProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.CompositeListenerChange;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.RefactoringContext;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeUpdater;
import org.eclipse.hyades.test.ui.navigator.refactoring.UpdateRefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public abstract class ReorgRefactoring
extends Refactoring {
    protected Change change;
    protected List seenElements;
    protected RefactoringContext context;

    public ReorgRefactoring() {
        this.initializeChanges();
    }

    private void initializeChanges() {
        this.change = null;
        this.seenElements = new LinkedList();
        this.context = new RefactoringContext();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.initializeChanges();
        pm.beginTask("", 3);
        try {
            try {
                TestUIUtilities.createProxyNodes((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (OperationCanceledException operationCanceledException) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.ReorgRefactoring_CANCELED_OPERATION_MSG);
                pm.done();
                return refactoringStatus;
            }
            this.change = this.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.worked(1);
            RefactoringStatus refactoringStatus = this.change.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            pm.worked(1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return "";
    }

    protected Change performContainerChildren(CompositeChange change, IContainer source, IPath newPath) {
        if (source.isAccessible()) {
            IResource[] resources;
            try {
                resources = source.members();
            }
            catch (CoreException e) {
                UiPlugin.logError("Unable to get members of container: " + source.getFullPath().toOSString(), e);
                return null;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    IFile file = (IFile)resources[i];
                    IProxyNode proxy = FileProxyNodeCache.getInstance().getProxy(file);
                    if (proxy != null && !this.seenElements.contains(proxy)) {
                        this.seenElements.add(proxy);
                        Change updateChange = null;
                        IProxyNodeUpdater updater = (IProxyNodeUpdater)proxy.getAdapter(IProxyNodeUpdater.class);
                        IPath dest = newPath.append(file.getName());
                        if (updater != null) {
                            updateChange = updater.createUpdateChange(this.context, source, dest);
                        }
                        CompositeChange composite = new CompositeChange(NLS.bind((String)RefactoringMessages.CHANGES_FOR_UPDATING, (Object)proxy.getText()));
                        if (updateChange != null) {
                            UpdateRefactoringEvent event = new UpdateRefactoringEvent(proxy, source, dest);
                            CompositeListenerChange compositeListener = new CompositeListenerChange(event);
                            compositeListener.add(updateChange);
                            composite.add((Change)compositeListener);
                        }
                        if (proxy instanceof IReferencerProxyNode) {
                            CompositeReferencerProxyNode ref = new CompositeReferencerProxyNode(proxy);
                            Iterator it = ref.getReferenceTypes().iterator();
                            while (it.hasNext()) {
                                this.createRenameReferencerTypeChildren(composite, ref, (String)it.next(), dest);
                            }
                        }
                        change.add((Change)composite);
                    }
                } else {
                    this.performContainerChildren(change, (IContainer)resources[i], newPath.append(resources[i].getName()));
                }
                ++i;
            }
        }
        return change;
    }

    private void createRenameReferencerTypeChildren(CompositeChange change, CompositeReferencerProxyNode ref, String type, IPath destinationPath) {
        String oppType = ReferenceTypeRegistry.getInstance().getOppositeReferenceType(type);
        if (ReferenceTypeRegistry.getInstance().isExplicit(oppType)) {
            CompositeChange c = new CompositeChange(ReferenceTypeRegistry.getInstance().getName(type));
            for (IProxyNode proxy : ref.getReferences(type)) {
                Change updateChange;
                IProxyNodeUpdater updater = (IProxyNodeUpdater)proxy.getAdapter(IProxyNodeUpdater.class);
                if (updater == null || (updateChange = updater.createUpdateChange(this.context, ref, type, destinationPath)) == null) continue;
                UpdateRefactoringEvent event = new UpdateRefactoringEvent(proxy, ref, type, destinationPath);
                CompositeListenerChange compositeListener = new CompositeListenerChange(event);
                compositeListener.add(updateChange);
                c.add((Change)compositeListener);
            }
            if (c.getChildren().length > 0) {
                change.add((Change)c);
            }
        }
    }
}

