/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.test.ui.navigator.refactoring.ITestNavigatorRefactoringListener;
import org.eclipse.hyades.test.ui.navigator.refactoring.RefactoringEvent;

public class TestNavigatorRefactoringListenerManager {
    private List[] listenerArray = new List[6];
    private static TestNavigatorRefactoringListenerManager instance = null;

    private TestNavigatorRefactoringListenerManager() {
        int i = 0;
        while (i < 6) {
            this.listenerArray[i] = new ArrayList();
            ++i;
        }
    }

    public static TestNavigatorRefactoringListenerManager getInstance() {
        if (instance == null) {
            instance = new TestNavigatorRefactoringListenerManager();
        }
        return instance;
    }

    public void addListener(ITestNavigatorRefactoringListener listener) {
        if (listener == null) {
            return;
        }
        int kind = listener.getKind();
        if (kind < 6) {
            this.listenerArray[kind].add(listener);
        }
    }

    public void removeListener(ITestNavigatorRefactoringListener listener) {
        if (listener == null) {
            return;
        }
        boolean done = false;
        int i = 0;
        while (i < 6 && !done) {
            done = this.listenerArray[i].remove(listener);
            ++i;
        }
    }

    public static void triggerStart(RefactoringEvent event) {
        int kind = event.getKind();
        if (kind >= 6) {
            return;
        }
        List allListener = TestNavigatorRefactoringListenerManager.getInstance().listenerArray[kind];
        if (allListener == null) {
            return;
        }
        for (ITestNavigatorRefactoringListener listener : allListener) {
            if (!listener.startEnable()) continue;
            listener.start(event);
        }
    }

    public static void triggerEnd(RefactoringEvent event) {
        int kind = event.getKind();
        if (kind >= 6) {
            return;
        }
        List allListener = TestNavigatorRefactoringListenerManager.getInstance().listenerArray[kind];
        if (allListener == null) {
            return;
        }
        for (ITestNavigatorRefactoringListener listener : allListener) {
            if (!listener.endEnable()) continue;
            listener.end(event);
        }
    }
}

