/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.util.ZipUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.osgi.framework.Bundle;

public class TrashBox {
    private static final String TRASH_BOX_NAME = ".trashbox";
    private static TrashBox instance = null;
    private static HashMap<String, String> deletedResourceMap = null;
    private static HashMap<String, Object> deletedProjects = null;
    private static File trashDir = null;

    private TrashBox() throws Exception {
        deletedResourceMap = new HashMap();
        deletedProjects = new HashMap();
        trashDir = new File(Platform.getStateLocation((Bundle)Platform.getBundle((String)UiPlugin.getID())).append(TRASH_BOX_NAME).toOSString());
        if (!trashDir.exists()) {
            if (!trashDir.mkdirs()) {
                throw new Exception("can not create trashbox");
            }
        } else {
            if (!trashDir.isDirectory()) {
                throw new Exception("trashbox exists and is not a directory");
            }
            File[] contents = trashDir.listFiles();
            if (contents != null) {
                int i = 0;
                while (i < contents.length) {
                    contents[i].delete();
                    ++i;
                }
            }
        }
        trashDir.deleteOnExit();
    }

    public static TrashBox instance() throws Exception {
        if (instance == null) {
            instance = new TrashBox();
        }
        return instance;
    }

    public void trashProject(IProject project, boolean physicalDelete) throws Exception {
        String deletedResourceName = project.getLocation().toOSString();
        if (project.isOpen()) {
            deletedProjects.put(deletedResourceName, project.getDescription());
        } else {
            deletedProjects.put(deletedResourceName, project.getName());
        }
        if (physicalDelete) {
            this.trashResource((IResource)project);
        }
    }

    public void trashResource(IResource resource) throws Exception {
        if (resource.exists()) {
            File target = null;
            target = File.createTempFile("deleted", ".zip", trashDir);
            String deletedResourceName = resource.getLocation().toOSString();
            ZipUtils zip = new ZipUtils(deletedResourceName, target.getAbsolutePath());
            zip.zip();
            target.deleteOnExit();
            deletedResourceMap.put(deletedResourceName, target.getAbsolutePath());
        }
    }

    public void untrashProject(String projectName) throws Exception {
        this.untrashResource(projectName);
        Object info = deletedProjects.get(projectName);
        if (info != null) {
            if (info instanceof IProjectDescription) {
                IProjectDescription desc = (IProjectDescription)info;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(desc.getName());
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject((String)info);
                project.create((IProgressMonitor)new NullProgressMonitor());
            }
            deletedProjects.remove(projectName);
        }
    }

    public void untrashResource(String resourceName) throws Exception {
        String zipName = deletedResourceMap.get(resourceName);
        if (zipName == null) {
            return;
        }
        ZipUtils zip = new ZipUtils(resourceName, zipName);
        zip.unzip();
        zip.deleteteZip();
        deletedResourceMap.remove(resourceName);
    }

    public void cleanTrash() {
        File[] contents = trashDir.listFiles();
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                contents[i].delete();
                ++i;
            }
        }
        deletedResourceMap.clear();
        deletedProjects.clear();
    }

    public Change createUntrashChange(IResource resource) {
        if (resource instanceof IProject) {
            return new UntrashProjectChange((IProject)resource);
        }
        return new UntrashResourceChange(resource);
    }

    public Change createCleanTrashChange() {
        return new CleanTrashChange();
    }

    public Change createRefreshOnUndoChange() {
        return new RefreshOnUndoChange();
    }

    private class CleanTrashChange
    extends CompositeChange {
        public CleanTrashChange() {
            super("");
            super.markAsSynthetic();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Change undo = super.perform(pm);
            TrashBox.this.cleanTrash();
            return undo;
        }

        public boolean isEnabled() {
            boolean needToPerform = true;
            Change[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                needToPerform &= children[i].isEnabled();
                ++i;
            }
            return needToPerform;
        }
    }

    private class RefreshOnUndoChange
    extends CompositeChange {
        public RefreshOnUndoChange() {
            super("");
            super.markAsSynthetic();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Change undo = super.perform(pm);
            CompositeChange c = new CompositeChange("");
            c.add((Change)new RefreshWorkspaceChange());
            c.add(undo);
            return c;
        }

        public boolean isEnabled() {
            boolean needToPerform = true;
            Change[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                needToPerform &= children[i].isEnabled();
                ++i;
            }
            return needToPerform;
        }
    }

    private class RefreshWorkspaceChange
    extends Change {
        private RefreshWorkspaceChange() {
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "refreshing workspace";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            return null;
        }
    }

    private class UntrashProjectChange
    extends Change {
        private String projectName = null;

        public UntrashProjectChange(IProject project) {
            this.projectName = project.getLocation().toOSString();
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "retrieving project from trash";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Object val = deletedProjects.get(this.projectName);
            if (val == null) {
                return null;
            }
            try {
                try {
                    TrashBox.this.untrashProject(this.projectName);
                }
                catch (Exception e) {
                    UiPlugin.logError("error while retrieving project : " + this.projectName);
                    UiPlugin.logError(e);
                    pm.worked(1);
                    return null;
                }
            }
            finally {
                pm.worked(1);
            }
            return null;
        }
    }

    private class UntrashResourceChange
    extends Change {
        private String resourceName = null;

        public UntrashResourceChange(IResource resource) {
            this.resourceName = resource.getLocation().toOSString();
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "retrieving resource from trash";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            try {
                try {
                    TrashBox.this.untrashResource(this.resourceName);
                }
                catch (Exception e) {
                    UiPlugin.logError("error while retrieving resource : " + this.resourceName);
                    UiPlugin.logError(e);
                    pm.worked(1);
                    return null;
                }
            }
            finally {
                pm.worked(1);
            }
            return null;
        }
    }
}

