/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class UpdateModelChange
extends Change {
    private EObjectProxyNode referencer;
    private EMFRefactoringTransaction context;

    public UpdateModelChange(EObjectProxyNode node, IRefactoringContext context) {
        this.referencer = node;
        this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction("org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction");
        Assert.isNotNull((Object)this.context);
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.UPDATE_REFERENCES, (Object)this.referencer.getText());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Resource res = this.context.getResourceSet().getResource(this.referencer.getOriginatorURI().trimFragment(), true);
        EcoreUtil.resolveAll((Resource)res);
        this.context.addSavedResource(res);
        return new UndoUpdateModelChange();
    }

    public Object getModifiedElement() {
        return this.referencer;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    private class UndoUpdateModelChange
    extends Change {
        private UndoUpdateModelChange() {
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "UndoUpdateModelChange";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            return null;
        }
    }
}

