/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ReportGeneratorPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private ReportManager reportManager;
    private TableViewer tableViewer;
    private ArrayList tableElements = new ArrayList();
    private Button btnAdd;
    private Button btnRemove;
    private Button btnRename;
    private Button btnTest;

    public ReportGeneratorPage() {
        this.setPreferenceStore(UiPlugin.getInstance().getPreferenceStore());
        this.reportManager = TestUI.getReportManager();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        composite.setLayout((Layout)new GridLayout());
        Group reportDefinationsGroup = new Group(composite, 16);
        reportDefinationsGroup.setLayout((Layout)new GridLayout());
        reportDefinationsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        reportDefinationsGroup.setText(UiPluginResourceBundle.preferences_report_definations_Group);
        this.createTable((Composite)reportDefinationsGroup);
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UiPlugin.getID()) + ".rgpp0001");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Control createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createTableViewer(composite);
        Composite buttons = new Composite(composite, 0);
        GridData data = new GridData(2);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.initializeValues();
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnTest.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridDataUtil.createFill();
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(UiPluginResourceBundle.REP_COL_NAME);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn certificateColumn = new TableColumn(table, 16384);
        certificateColumn.setText(UiPluginResourceBundle.REP_COL_FILE);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof ReportDescription && !((ReportDescription)element).isDefinedByPlugin();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.tableViewer.getTable(), String.valueOf(UiPlugin.getID()) + ".rgpp0013");
    }

    private void createButtons(Composite parent) {
        this.btnAdd = new Button(parent, 8);
        this.btnAdd.setText(UiPluginResourceBundle.label_Add);
        this.btnAdd.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRemove = new Button(parent, 8);
        this.btnRemove.setText(UiPluginResourceBundle.label_Remove);
        this.btnRemove.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRemove.setEnabled(false);
        this.btnRename = new Button(parent, 8);
        this.btnRename.setText(UiPluginResourceBundle.label_Update);
        this.btnRename.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRename.setEnabled(false);
        this.btnTest = new Button(parent, 8);
        this.btnTest.setText(UiPluginResourceBundle.label_Test);
        this.btnTest.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnTest.setEnabled(false);
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.btnAdd, String.valueOf(UiPlugin.getID()) + ".rgpp0002");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.btnRemove, String.valueOf(UiPlugin.getID()) + ".rgpp0003");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.btnRename, String.valueOf(UiPlugin.getID()) + ".rgpp0004");
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.btnTest, String.valueOf(UiPlugin.getID()) + ".rgpp0005");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        StructuredSelection selection;
        ReportDescription reportDescription;
        block15: {
            IStructuredSelection elem;
            block17: {
                Object obj;
                block16: {
                    block14: {
                        if (event.widget != this.btnAdd) break block14;
                        ReportDialog dlg = new ReportDialog(this.getShell(), null);
                        dlg.open();
                        if (dlg.getReturnCode() == 0) {
                            ReportDescription rptDesc = dlg.getReportDefinition();
                            this.reportManager.addReportDefinition((IReportDescription)rptDesc);
                            this.tableElements.add(rptDesc);
                            this.tableViewer.refresh();
                            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)rptDesc));
                        }
                        break block15;
                    }
                    if (event.widget != this.btnRemove) break block16;
                    elem = (IStructuredSelection)this.tableViewer.getSelection();
                    if (elem.size() > 0) {
                        for (IReportDescription rptDesc : elem) {
                            this.reportManager.removeReportDefinition(rptDesc);
                            this.tableElements.remove(rptDesc);
                        }
                        this.tableViewer.refresh();
                    }
                    break block15;
                }
                if (event.widget != this.btnRename) break block17;
                elem = (IStructuredSelection)this.tableViewer.getSelection();
                if (elem.size() <= 0 || !((obj = elem.getFirstElement()) instanceof ReportDescription)) break block15;
                ReportDialog dlg = new ReportDialog(this.getShell(), (ReportDescription)obj);
                dlg.open();
                if (dlg.getReturnCode() != 0) break block15;
                this.tableViewer.refresh();
                break block15;
            }
            if (event.widget == this.btnTest && (elem = (IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
                for (Object obj : elem) {
                    String message;
                    String className;
                    if (!(obj instanceof ReportDescription)) continue;
                    ReportDescription reportDescription2 = (ReportDescription)obj;
                    try {
                        if (reportDescription2.getReportGenerator() != null) {
                            className = "";
                            if (reportDescription2.getClassName() != null) {
                                className = reportDescription2.getClassName();
                            }
                            message = NLS.bind((String)UiPluginResourceBundle.preferences_report_TestButton_Succeed, (Object)className);
                            MessageDialog.openInformation((Shell)this.getShell(), (String)UiPluginResourceBundle.W_SUCCESS, (String)message);
                            continue;
                        }
                        className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        message = NLS.bind((String)UiPluginResourceBundle._ERROR_preferences_report_TestButton_Fail_CantFind, (Object)className);
                        MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)message);
                    }
                    catch (ClassCastException classCastException) {
                        className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        message = NLS.bind((String)UiPluginResourceBundle._ERROR_preferences_report_TestButton_Fail_Instance, (Object)className);
                        MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)message);
                    }
                    catch (Exception exception) {
                        className = "";
                        if (reportDescription2.getClassName() != null) {
                            className = reportDescription2.getClassName();
                        }
                        message = NLS.bind((String)UiPluginResourceBundle._ERROR_preferences_report_TestButton_Fail_CantFind, (Object)className);
                        MessageDialog.openError((Shell)this.getShell(), (String)UiPluginResourceBundle.W_ERROR, (String)message);
                    }
                }
            }
        }
        ISelection sel = this.tableViewer.getSelection();
        this.btnRename.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnTest.setEnabled(false);
        if (sel != null && sel instanceof StructuredSelection && (reportDescription = (ReportDescription)(selection = (StructuredSelection)sel).getFirstElement()) != null) {
            boolean isDefinedByPlugin = reportDescription.isDefinedByPlugin();
            this.btnRename.setEnabled(!isDefinedByPlugin);
            this.btnRemove.setEnabled(!isDefinedByPlugin);
            this.btnTest.setEnabled(true);
        }
    }

    protected void openErrorMessageBox(String message) {
    }

    public Point computeSize() {
        Point p = super.computeSize();
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.reportManager.saveIntoPreferenceStore();
        return true;
    }

    private void initializeValues() {
        IReportDescription[] list = this.reportManager.getReportDescriptions();
        int idx = 0;
        while (idx < list.length) {
            this.tableElements.add(list[idx]);
            ++idx;
        }
        this.tableViewer.setInput((Object)this.tableElements);
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ArrayList) {
                return ((ArrayList)element).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return TestUIImages.INSTANCE.getImage("report_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ReportDescription) {
                ReportDescription myTableElement = (ReportDescription)element;
                if (columnIndex == 0) {
                    return myTableElement.getName();
                }
                if (columnIndex == 1) {
                    return myTableElement.getClassName();
                }
            }
            return "";
        }
    }

    public class ReportDialog
    extends Dialog
    implements Listener {
        private ReportDescription report;
        private ReportGeneratorUI reportGeneratorUI;

        public ReportDialog(Shell shell, ReportDescription report) {
            super(shell);
            this.report = report;
        }

        protected Control createDialogArea(Composite parent) {
            if (this.report == null) {
                this.getShell().setText(UiPluginResourceBundle.ADD_REPORT_DESC_DLG);
            } else {
                this.getShell().setText(UiPluginResourceBundle.EDIT_REPORT_DESC_DLG);
            }
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)GridDataUtil.createFill());
            result.setLayout((Layout)new GridLayout());
            this.reportGeneratorUI = new ReportGeneratorUI(this.getShell());
            Composite content = this.reportGeneratorUI.createControl(result);
            if (this.report != null) {
                this.reportGeneratorUI.setName(this.report.getName());
                this.reportGeneratorUI.setClassname(this.report.getClassName());
                this.reportGeneratorUI.setClasspath(this.report.getClassPath());
            }
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)content, String.valueOf(UiPlugin.getID()) + ".rgpp0007");
            return content;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.reportGeneratorUI.registerListener(this);
            if (this.report == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.report == null) {
                this.report = new ReportDescription(((Object)((Object)this)).getClass().getClassLoader(), this.reportGeneratorUI.getName(), this.reportGeneratorUI.getClassName(), this.reportGeneratorUI.getClassPath());
            } else {
                this.report.setName(this.reportGeneratorUI.getName());
                this.report.setClassName(this.reportGeneratorUI.getClassName());
                this.report.setClassPath(this.reportGeneratorUI.getClassPath());
            }
            super.okPressed();
        }

        public ReportDescription getReportDefinition() {
            return this.report;
        }

        public void handleEvent(Event e) {
            this.getButton(0).setEnabled(!this.reportGeneratorUI.getName().equals("") && !this.reportGeneratorUI.getClassName().equals(""));
        }
    }

    private class ReportGeneratorUI
    implements SelectionListener,
    ModifyListener {
        private Text _classname;
        private Text _name;
        private Text _classpath;
        private Button _browseClass;
        private Button _browseDirPath;
        private Button _browseJarPath;
        private Shell shell;
        private Listener _listener;

        public ReportGeneratorUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createArgumentsControl(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            label.setText(UiPluginResourceBundle.CLASSPATH);
            label.setLayoutData((Object)gd);
            this._classpath = new Text(parent, 2882);
            gd = GridDataUtil.createFill();
            gd.heightHint = 100;
            gd.widthHint = 250;
            this._classpath.setLayoutData((Object)gd);
            Composite btnGroup = new Composite(parent, 0);
            gd = GridDataUtil.createVerticalFill();
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            btnGroup.setLayoutData((Object)gd);
            btnGroup.setLayout((Layout)layout);
            this._browseDirPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            this._browseDirPath.setLayoutData((Object)gd);
            this._browseDirPath.setText(UiPluginResourceBundle.ADD_DIRECTORY);
            this._browseJarPath = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this._browseJarPath.setLayoutData((Object)gd);
            this._browseJarPath.setText(UiPluginResourceBundle.ADD_JAR);
            this._browseDirPath.addSelectionListener((SelectionListener)this);
            this._browseJarPath.addSelectionListener((SelectionListener)this);
            this._classname.addModifyListener((ModifyListener)this);
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._classpath, String.valueOf(UiPlugin.getID()) + ".lpui0001");
            return parent;
        }

        public Composite createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.verticalSpacing = 5;
            layout.horizontalSpacing = 5;
            content.setLayout((Layout)layout);
            GridData gd = GridDataUtil.createFill();
            gd.horizontalIndent = 5;
            content.setLayoutData((Object)gd);
            Label label = new Label(content, 0);
            label.setText(UiPluginResourceBundle.label_Name);
            this._name = new Text(content, 2052);
            gd = GridDataUtil.createHorizontalFill();
            gd.horizontalSpan = 2;
            this._name.setLayoutData((Object)gd);
            label = new Label(content, 0);
            label.setText(UiPluginResourceBundle.preference_report_Classfile);
            this._classname = new Text(content, 2052);
            this._classname.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            Composite btnGroup = new Composite(content, 0);
            gd = GridDataUtil.createVerticalFill();
            layout = new GridLayout();
            layout.numColumns = 1;
            btnGroup.setLayoutData((Object)gd);
            btnGroup.setLayout((Layout)layout);
            this._browseClass = new Button(btnGroup, 0x1000008);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this._browseClass.setLayoutData((Object)gd);
            this._browseClass.setText(UiPluginResourceBundle.BROWSE);
            this._browseClass.addSelectionListener((SelectionListener)this);
            this._name.setFocus();
            this._name.addModifyListener((ModifyListener)this);
            this.createArgumentsControl(content);
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._classname, String.valueOf(UiPlugin.getID()) + ".rgpp0011");
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._classpath, String.valueOf(UiPlugin.getID()) + ".rgpp0010");
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._name, String.valueOf(UiPlugin.getID()) + ".rgpp0012");
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._browseClass, String.valueOf(UiPlugin.getID()) + ".rgpp0006");
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._browseDirPath, String.valueOf(UiPlugin.getID()) + ".rgpp0008");
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this._browseJarPath, String.valueOf(UiPlugin.getID()) + ".rgpp0009");
            return content;
        }

        public String getClassName() {
            return this._classname.getText().trim();
        }

        public String getClassPath() {
            return this._classpath.getText().trim();
        }

        public String getName() {
            return this._name.getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent e) {
            String osName = System.getProperty("os.name");
            if (e.widget == this._browseClass) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.class"});
                dlg.open();
                String fileName = dlg.getFileName();
                if (fileName != null && !fileName.equals("")) {
                    String oldClassPath;
                    if (fileName.endsWith(".class")) {
                        fileName = fileName.substring(0, fileName.length() - 6);
                    }
                    this._classname.setText(fileName);
                    String classpath = dlg.getFilterPath();
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = String.valueOf(classpath) + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    this._classpath.setText(String.valueOf(oldClassPath) + classpath);
                }
            } else if (e.widget == this._browseDirPath) {
                DirectoryDialog dlg = new DirectoryDialog(this.shell);
                String classpath = dlg.open();
                if (classpath != null && !classpath.equals("")) {
                    String oldClassPath;
                    if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                        classpath = String.valueOf(classpath) + "\\";
                    }
                    oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    classpath = String.valueOf(oldClassPath) + classpath;
                    this._classpath.setText(classpath);
                    this._classpath.setFocus();
                }
            } else if (e.widget == this._browseJarPath) {
                FileDialog dlg = new FileDialog(this.shell);
                dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
                dlg.open();
                String classpath = dlg.getFileName();
                if (classpath != null && !classpath.equals("")) {
                    classpath = String.valueOf(dlg.getFilterPath()) + File.separator + classpath;
                    String oldClassPath = this._classpath.getText().trim();
                    oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : String.valueOf(oldClassPath) + File.pathSeparator;
                    classpath = String.valueOf(oldClassPath) + classpath;
                    this._classpath.setText(classpath);
                }
            }
        }

        public void modifyText(ModifyEvent e) {
            this.notifyListener();
        }

        public void setClassname(String text) {
            this._classname.setText(text);
        }

        public void setClasspath(String text) {
            if (text != null) {
                this._classpath.setText(text);
            }
        }

        public void setName(String text) {
            this._name.setText(text);
        }

        public void registerListener(Listener listener) {
            this._listener = listener;
        }

        public void notifyListener() {
            if (this._listener != null) {
                this._listener.handleEvent(null);
            }
        }
    }
}

