/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InvocationEventSearchProvider
extends ExecutionEventSearchProvider
implements SelectionListener {
    private boolean searchSuccessful;
    private Button successful;
    private boolean searchUnsuccessful;
    private Button unsuccessful;
    private boolean searchUnattempted;
    private Button unattempted;

    public void createContents(Composite parent) {
        super.createContents(parent);
        Group group = new Group(parent, 16);
        group.setText(UiPluginResourceBundle.TestLogSearch_LimitToInvocationStatus);
        group.setLayoutData((Object)new GridData());
        group.setLayout((Layout)new GridLayout(2, true));
        this.successful = new Button((Composite)group, 32);
        this.successful.setText(TPFInvocationStatus.SUCCESSFUL_LITERAL.getLabel());
        this.successful.addSelectionListener((SelectionListener)this);
        this.unsuccessful = new Button((Composite)group, 32);
        this.unsuccessful.setText(TPFInvocationStatus.UNSUCCESSFUL_LITERAL.getLabel());
        this.unsuccessful.addSelectionListener((SelectionListener)this);
        this.unattempted = new Button((Composite)group, 32);
        this.unattempted.setText(TPFInvocationStatus.UNATTEMPTED_LITERAL.getLabel());
        this.unattempted.addSelectionListener((SelectionListener)this);
    }

    public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
        SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);
        this.setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent());
        LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
        LogicalExpression or = this.createORExpression();
        if (this.searchSuccessful) {
            BinaryExpression successfulSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), TPFInvocationStatus.SUCCESSFUL_LITERAL.toString());
            or.getArguments().add((Object)successfulSearch);
        }
        if (this.searchUnsuccessful) {
            BinaryExpression unsuccessfulSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), TPFInvocationStatus.UNSUCCESSFUL_LITERAL.toString());
            or.getArguments().add((Object)unsuccessfulSearch);
        }
        if (this.searchUnattempted) {
            BinaryExpression unattemptedSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), TPFInvocationStatus.UNATTEMPTED_LITERAL.toString());
            or.getArguments().add((Object)unattemptedSearch);
        }
        this.combineExecutionEventAndElementExpressions(query, executionEventOR, or);
        return query;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.successful) {
            this.searchSuccessful = this.successful.getSelection();
        } else if (e.widget == this.unsuccessful) {
            this.searchUnsuccessful = this.unsuccessful.getSelection();
        } else if (e.widget == this.unattempted) {
            this.searchUnattempted = this.unattempted.getSelection();
        }
        super.widgetSelected(e);
    }
}

