/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class MessageEventSearchProvider
extends ExecutionEventSearchProvider
implements SelectionListener {
    private boolean searchInfo;
    private Button info;
    private boolean searchError;
    private Button error;
    private boolean searchWarning;
    private Button warning;

    public void createContents(Composite parent) {
        super.createContents(parent);
        Group group = new Group(parent, 16);
        group.setText(UiPluginResourceBundle.TestLogSearch_LimitToMessageSeverity);
        group.setLayoutData((Object)new GridData());
        group.setLayout((Layout)new GridLayout(3, true));
        this.info = new Button((Composite)group, 32);
        this.info.setText(TPFSeverity.INFO_LITERAL.getLabel());
        this.info.addSelectionListener((SelectionListener)this);
        this.error = new Button((Composite)group, 32);
        this.error.setText(TPFSeverity.ERROR_LITERAL.getLabel());
        this.error.addSelectionListener((SelectionListener)this);
        this.warning = new Button((Composite)group, 32);
        this.warning.setText(TPFSeverity.WARNING_LITERAL.getLabel());
        this.warning.addSelectionListener((SelectionListener)this);
    }

    public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
        SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);
        this.setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent());
        LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
        LogicalExpression or = this.createORExpression();
        if (this.searchInfo) {
            BinaryExpression infoSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), TPFSeverity.INFO_LITERAL.toString());
            or.getArguments().add((Object)infoSearch);
        }
        if (this.searchError) {
            BinaryExpression errorSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), TPFSeverity.ERROR_LITERAL.toString());
            or.getArguments().add((Object)errorSearch);
        }
        if (this.searchWarning) {
            BinaryExpression warningSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), TPFSeverity.WARNING_LITERAL.toString());
            or.getArguments().add((Object)warningSearch);
        }
        this.combineExecutionEventAndElementExpressions(query, executionEventOR, or);
        return query;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.info) {
            this.searchInfo = this.info.getSelection();
        } else if (e.widget == this.error) {
            this.searchError = this.error.getSelection();
        } else if (e.widget == this.warning) {
            this.searchWarning = this.warning.getSelection();
        }
        super.widgetSelected(e);
    }
}

