/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TypedEventSearchProvider
extends ExecutionEventSearchProvider
implements SelectionListener {
    private boolean searchStart;
    private Button start;
    private boolean searchStop;
    private Button stop;

    public void createContents(Composite parent) {
        super.createContents(parent);
        Group group = new Group(parent, 16);
        group.setText(UiPluginResourceBundle.TestLogSearch_LimitToTypes);
        group.setLayoutData((Object)new GridData());
        group.setLayout((Layout)new GridLayout(2, true));
        this.start = new Button((Composite)group, 32);
        this.start.setText(TPFExecutionType.START_LITERAL.getLabel());
        this.start.addSelectionListener((SelectionListener)this);
        this.stop = new Button((Composite)group, 32);
        this.stop.setText(TPFExecutionType.STOP_LITERAL.getLabel());
        this.stop.addSelectionListener((SelectionListener)this);
    }

    public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
        SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);
        this.setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent());
        LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
        LogicalExpression or = this.createORExpression();
        if (this.searchStart) {
            BinaryExpression startSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent_Type(), TPFExecutionType.START_LITERAL.toString());
            or.getArguments().add((Object)startSearch);
        }
        if (this.searchStop) {
            BinaryExpression stopSearch = this.createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFTypedEvent_Type(), TPFExecutionType.STOP_LITERAL.toString());
            or.getArguments().add((Object)stopSearch);
        }
        this.combineExecutionEventAndElementExpressions(query, executionEventOR, or);
        return query;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.start) {
            this.searchStart = this.start.getSelection();
        } else if (e.widget == this.stop) {
            this.searchStop = this.stop.getSelection();
        }
        super.widgetSelected(e);
    }
}

