/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.hyades.ui.util.IDisposable;

public class FixedSizeJobPool
implements IDisposable {
    private int maxJobs;
    private int runningJobs = 0;
    private List queue = Collections.synchronizedList(new LinkedList());
    private Object lock = new Object();
    private boolean disposed;
    private IJobChangeListener jobListener = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            if (event.getResult() != null) {
                Object object = FixedSizeJobPool.this.lock;
                synchronized (object) {
                    FixedSizeJobPool fixedSizeJobPool = FixedSizeJobPool.this;
                    fixedSizeJobPool.runningJobs = fixedSizeJobPool.runningJobs - 1;
                    FixedSizeJobPool.this.doScheduleJob();
                }
            }
        }
    };

    public FixedSizeJobPool(int maxJobs) {
        this.maxJobs = maxJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJob(Job job) {
        this.queue.add(job);
        Object object = this.lock;
        synchronized (object) {
            if (this.runningJobs < this.maxJobs) {
                this.doScheduleJob();
            }
        }
    }

    private void doScheduleJob() {
        if (this.disposed) {
            return;
        }
        if (!this.queue.isEmpty()) {
            Job job = (Job)this.queue.remove(0);
            job.addJobChangeListener(this.jobListener);
            ++this.runningJobs;
            job.schedule();
        }
    }

    public void dispose() {
        this.disposed = true;
    }
}

