/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceRegistry;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.reference.ReferenceTypeRegistry;

public class ReferenceDisplayUtils {
    private static final String basis = "--";
    private static final String owned = "==";
    private static final String opposite = "<";
    private static final String direct = ">";
    private static final String implicitStart = "[";
    private static final String implicitEnd = "]";
    private static ReferenceTypeRegistry factory = ReferenceTypeRegistry.getInstance();

    public static String referenceToString(String type) {
        boolean implicit;
        StringBuffer buff = new StringBuffer();
        String oppositeRef = factory.getOppositeReferenceType(type);
        if (oppositeRef != null) {
            boolean bl = implicit = !factory.isExplicit(oppositeRef);
            if (implicit) {
                buff.append(implicitStart);
            }
            buff.append(opposite);
            if (factory.owns(oppositeRef)) {
                buff.append(owned);
            } else {
                buff.append(basis);
            }
            if (implicit) {
                buff.append(implicitEnd);
            }
        }
        boolean bl = implicit = !factory.isExplicit(type);
        if (implicit) {
            buff.append(implicitStart);
        }
        if (factory.owns(type)) {
            buff.append(owned);
        } else {
            buff.append(basis);
        }
        if (implicit) {
            buff.append(implicitEnd);
        }
        buff.append(direct);
        return buff.toString();
    }

    public static Set getProjectReferenceFiles(IProject project) {
        return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferencerFiles();
    }

    public static Set getReferenceTypes(IProject project, IFile file) {
        return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferenceTypes(file);
    }

    public static Collection getReference(IProject project, IFile file, String type) {
        return ReferenceRegistry.getInstance().getProjectReferenceRegistry(project).getReferences(file, type);
    }
}

