/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;

public class SpecialFieldsBidiListener
implements BidiSegmentListener {
    private String delimiters;

    public SpecialFieldsBidiListener(String delimiters) {
        this.delimiters = delimiters;
    }

    public void lineGetSegments(BidiSegmentEvent event) {
        String text = event.lineText;
        if (text == null) {
            return;
        }
        int length = text.length();
        if (length < 2) {
            return;
        }
        int[] segments = new int[length + 1];
        int charIdx = 1;
        int segmentIdx = 0;
        while (charIdx < length) {
            if (this.delimiters.indexOf(text.charAt(charIdx)) != -1) {
                segments[++segmentIdx] = charIdx;
            }
            ++charIdx;
        }
        if (segmentIdx == 0) {
            return;
        }
        segments[0] = 0;
        segments[++segmentIdx] = length;
        if (++segmentIdx <= length) {
            event.segments = new int[segmentIdx];
            System.arraycopy(segments, 0, event.segments, 0, segmentIdx);
        } else {
            event.segments = segments;
        }
    }

    public static SpecialFieldsBidiListener createPackageFieldBidiListener() {
        return new SpecialFieldsBidiListener(".");
    }

    public static SpecialFieldsBidiListener createPathFieldBidiListener() {
        return new SpecialFieldsBidiListener(".:\\/");
    }
}

