/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.trace.ui.provisional.ITraceUIHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.wizard.ICustomLocationNameValidation;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TestUIUtilities
implements ICustomLocationNameValidation {
    private static TestUIUtilities instance = null;

    private TestUIUtilities() {
    }

    public static TestUIUtilities instance() {
        if (instance == null) {
            instance = new TestUIUtilities();
        }
        return instance;
    }

    public boolean isNameValid(String resourceName, IContainer container) {
        return TestUIUtil.validateResourcePath(resourceName, container) == 0;
    }

    public static void testConnection() {
        TestUIUtilities.testConnection(UiPlugin.getInstance().getPreferenceStore().getString("default_host_name"));
    }

    public static void testConnection(CMNNodeType node) {
        TestUIUtilities.testConnection(node.getHostname());
    }

    public static void testConnection(String hostName) {
        TestUIUtilities.testConnection(hostName, UiPlugin.getInstance().getPreferenceStore().getString("default_port"));
    }

    public static void testConnection(final String hostName, final String port) {
        final Shell shell = Display.getDefault().getActiveShell();
        if (!TestUIUtilities.isValidHostName(hostName)) {
            MessageDialog.openError((Shell)shell, (String)UiPluginResourceBundle.TEST_CONNECTION_NAME, (String)UiPluginResourceBundle._ERROR_INVALID_HOST_NAME);
        } else if (!TestUIUtilities.isValidPort(port)) {
            MessageDialog.openError((Shell)shell, (String)UiPluginResourceBundle.TEST_CONNECTION_NAME, (String)UiPluginResourceBundle._ERROR_INVALID_PORT_RANGE);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    ConnectUtil connectUtil;
                    ITraceUIHelper traceUIHelper = ITraceUIHelper.INSTANCE;
                    if (traceUIHelper != null && (connectUtil = new ConnectUtil(hostName.trim(), port.trim(), traceUIHelper.getTraceUIApplication())).connect() == 0) {
                        MessageDialog.openInformation((Shell)shell, (String)UiPluginResourceBundle.TEST_CONNECTION_NAME, (String)UiPluginResourceBundle.TEST_CONNECTION_SUCCESS);
                    }
                }
            };
            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)runnable);
        }
    }

    public static boolean isValidPort(String port) {
        if (port != null && port.trim().length() > 0) {
            try {
                int portNumber = Integer.parseInt(port.trim());
                return portNumber >= 0 && portNumber <= 65535;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }

    public static boolean isValidHostName(String hostName) {
        String[] segments;
        if (hostName != null && hostName.length() > 0 && hostName.length() < 256 && hostName.charAt(0) != '.' && hostName.charAt(hostName.length() - 1) != '.' && (segments = hostName.split("\\.")).length > 0) {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                char[] characters = segment.toCharArray();
                if (characters.length < 1 || characters.length > 63 || characters[0] == '-' || characters[characters.length - 1] == '-') {
                    return false;
                }
                char[] cArray = characters;
                int n3 = characters.length;
                int n4 = 0;
                while (n4 < n3) {
                    char character = cArray[n4];
                    if (!(character >= '0' && character <= '9' || character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z' || character == '-' || character == ':' || character == '_')) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static void openTestPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    if (!activeWorkbenchWindow.getActivePage().getPerspective().getId().equals("org.eclipse.hyades.ui.perspective.TestPerspective")) {
                        workbench.showPerspective("org.eclipse.hyades.ui.perspective.TestPerspective", activeWorkbenchWindow);
                    }
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                }
            }
        });
    }

    public static void setEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] children = composite.getChildren();
        int counter = 0;
        while (counter < children.length) {
            if (children[counter] instanceof Composite) {
                TestUIUtilities.setEnabled((Composite)children[counter], enabled);
            } else {
                children[counter].setEnabled(enabled);
            }
            ++counter;
        }
    }

    public static void recursiveRefreshProxy(IResource resource) {
        IFileProxyManager proxManager = TestNavigator.getFileProxyManager();
        if (proxManager == null) {
            proxManager = new FileProxyManager();
        }
        TestUIUtilities.internalRecursiveRefreshProxy(proxManager, resource);
    }

    private static void internalRecursiveRefreshProxy(IFileProxyManager proxManager, IResource resource) {
        if (resource.exists()) {
            if (resource instanceof IFile) {
                proxManager.updateProxy((IFile)resource, null);
                return;
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] children = container.members();
                    int counter = 0;
                    while (counter < children.length) {
                        TestUIUtilities.internalRecursiveRefreshProxy(proxManager, children[counter]);
                        ++counter;
                    }
                }
                catch (CoreException e) {
                    UiPlugin.logError(e);
                }
            }
        }
    }

    public static void createProxyNodes(IContainer rootContainer) {
        TestUIUtilities.createProxyNodes(rootContainer, null);
    }

    public static void createProxyNodes(IContainer container, IProgressMonitor progressMonitor) throws OperationCanceledException {
        if (progressMonitor != null) {
            progressMonitor.beginTask(RefactoringMessages.TestUIUtilities_CREATING_PROXIES_TASK, -1);
        }
        try {
            TestUIUtilities.internalCreateProxyNodes(container, progressMonitor);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    private static void internalCreateProxyNodes(IContainer container, IProgressMonitor progressMonitor) throws OperationCanceledException {
        if (container != null && container.isAccessible()) {
            try {
                IResource[] resources = container.members();
                int counter = 0;
                while (counter < resources.length) {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (resources[counter] instanceof IFile) {
                        FileProxyNodeCache.getInstance().getProxy((IFile)resources[counter]);
                    } else if (resources[counter] instanceof IContainer) {
                        TestUIUtilities.internalCreateProxyNodes((IContainer)resources[counter], progressMonitor);
                    }
                    ++counter;
                }
            }
            catch (CoreException c) {
                UiPlugin.logError(c);
            }
        }
    }
}

