/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private String source = null;
    private String zipFileName = null;
    private ZipOutputStream zipOutputStream = null;
    private ZipInputStream zipInputStream = null;

    public ZipUtils(String source, String zipFileName) {
        this.source = source;
        this.zipFileName = zipFileName;
    }

    public void deleteteZip() {
        File file = new File(this.zipFileName);
        if (file.exists()) {
            file.delete();
        }
    }

    private void createParentFolderIfNeeded(String entryName) throws Exception {
        File parentFile;
        File file = new File(entryName);
        String parentName = file.getParent();
        if (parentName != null && !(parentFile = new File(parentName)).exists() && !parentFile.mkdirs()) {
            throw new Exception("can't create folder <" + parentName + ">");
        }
    }

    public void unzip() throws Exception {
        ZipEntry entry;
        FileInputStream fis = new FileInputStream(this.zipFileName);
        this.zipInputStream = new ZipInputStream(fis);
        while ((entry = this.zipInputStream.getNextEntry()) != null) {
            int size;
            this.createParentFolderIfNeeded(entry.getName());
            if (entry.isDirectory()) {
                File dir = new File(entry.getName());
                if (dir.exists() || dir.mkdir()) continue;
                throw new Exception("can't create folder <" + entry.getName() + ">");
            }
            byte[] buffer = new byte[2048];
            FileOutputStream fos = new FileOutputStream(entry.getName());
            BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);
            while ((size = this.zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
        }
        this.zipInputStream.close();
        fis.close();
    }

    public void zip() throws Exception {
        File cpFile = new File(this.source);
        if (!cpFile.isFile() && !cpFile.isDirectory()) {
            throw new Exception("invalid source");
        }
        this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFileName));
        this.zipOutputStream.setLevel(9);
        this.zipFiles(cpFile);
        this.zipOutputStream.finish();
        this.zipOutputStream.close();
    }

    private void zipFiles(File cpFile) throws Exception {
        String zipEntryName = cpFile.getAbsolutePath();
        if (cpFile.isDirectory()) {
            ZipEntry dirEntry = new ZipEntry(String.valueOf(zipEntryName) + "/");
            this.zipOutputStream.putNextEntry(dirEntry);
            this.zipOutputStream.closeEntry();
            File[] fileList = cpFile.listFiles();
            int i = 0;
            while (i < fileList.length) {
                this.zipFiles(fileList[i]);
                ++i;
            }
        } else {
            FileInputStream theInputStream = null;
            try {
                byte[] b = new byte[(int)cpFile.length()];
                theInputStream = new FileInputStream(cpFile);
                theInputStream.read(b, 0, (int)cpFile.length());
                ZipEntry theZipEntry = new ZipEntry(zipEntryName);
                this.zipOutputStream.putNextEntry(theZipEntry);
                this.zipOutputStream.write(b, 0, (int)cpFile.length());
                this.zipOutputStream.closeEntry();
            }
            catch (Exception e) {
                if (theInputStream != null) {
                    theInputStream.close();
                }
                throw e;
            }
            theInputStream.close();
        }
    }
}

