/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVImportExportUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolExportCSVFileLocationPage;
import org.eclipse.hyades.test.ui.internal.wizard.DatapoolSelectionPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class DatapoolExportWizard
extends Wizard
implements IExportWizard {
    private DatapoolSelectionPage datapoolSelectionPage = null;
    private DatapoolExportCSVFileLocationPage csvFileLocationPage = null;
    private IStructuredSelection selection = null;

    public DatapoolExportWizard() {
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("export_datapool_wiz.gif"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(UiPluginResourceBundle.WIZ_EXP_DATAPOOL_TTL);
        this.selection = selection;
    }

    public void addPages() {
        this.datapoolSelectionPage = new DatapoolSelectionPage("datapoolSelection", this.selection);
        this.datapoolSelectionPage.setTitle(UiPluginResourceBundle.WIZ_EXP_DATAPOOL_TTL);
        this.datapoolSelectionPage.setDescription(UiPluginResourceBundle.WIZ_EXP_DATAPOOL_SEL_PG_DSC);
        this.addPage((IWizardPage)this.datapoolSelectionPage);
        this.csvFileLocationPage = new DatapoolExportCSVFileLocationPage("csvFileSelection");
        this.csvFileLocationPage.setTitle(UiPluginResourceBundle.WIZ_EXP_DATAPOOL_TTL);
        this.csvFileLocationPage.setDescription(UiPluginResourceBundle.WIZ_EXP_DATAPOOL_CSV_PG_DSC);
        this.addPage((IWizardPage)this.csvFileLocationPage);
    }

    public void createPageControls(Composite parent) {
        super.createPageControls(parent);
        IWorkbenchHelpSystem workbenchHelpSystem = PlatformUI.getWorkbench().getHelpSystem();
        workbenchHelpSystem.setHelp(this.datapoolSelectionPage.getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0003");
        workbenchHelpSystem.setHelp(this.csvFileLocationPage.getControl(), String.valueOf(UiPlugin.getID()) + ".dplw0003");
    }

    public boolean canFinish() {
        return this.csvFileLocationPage.isPageComplete() && this.datapoolSelectionPage.isPageComplete();
    }

    public boolean performFinish() {
        IDatapool datapool = this.datapoolSelectionPage.getSelectedDatapool();
        String csvFilePath = this.csvFileLocationPage.getCSVFilePath();
        boolean isEncrypted = this.datapoolSelectionPage.isSelectedDatapoolEncrypted();
        String password = this.datapoolSelectionPage.getEncryptedDatapoolPassword();
        try {
            MessageDialog overwriteDialog;
            if (isEncrypted) {
                DatapoolEncryptManager.decryptDatapool((IDatapool)datapool, (String)password);
            }
            if (new File(csvFilePath).exists() && (overwriteDialog = new MessageDialog(this.getShell(), UiPluginResourceBundle.WIZ_EXP_DATAPOOL_TTL, null, NLS.bind((String)UiPluginResourceBundle.WIZ_EXP_DATAPOOL_MSG_EXISTS, (Object)csvFilePath), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() != 0) {
                return false;
            }
            CSVImportExportUtil.getInstance().exportCSV(datapool, csvFilePath, this.csvFileLocationPage.getCSVFileFirstRowContainsVariableNames(), this.csvFileLocationPage.getCSVFileFirstColumnContainsEquivalenceClassNames(), this.csvFileLocationPage.getCSVFileCellsEnclosedInXMLTags(), this.csvFileLocationPage.getCSVFileEncoding());
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(csvFilePath));
            int counter = 0;
            while (counter < files.length) {
                try {
                    files[counter].refreshLocal(0, null);
                }
                catch (CoreException e) {
                    UiPlugin.logError(e);
                }
                ++counter;
            }
            return true;
        }
        catch (Exception e) {
            UiPlugin.logError(e);
            new ErrorDialog(this.getShell(), UiPluginResourceBundle.W_ERROR, NLS.bind((String)UiPluginResourceBundle._ERROR_WIZ_DATAPOOL_CSV_ERRDLG_EXPFILE, (Object[])new String[]{datapool.getName(), csvFilePath}), (IStatus)new Status(4, "org.eclipse.hyades.test.ui", 0, e.toString(), (Throwable)e), 4).open();
        }
        finally {
            if (isEncrypted) {
                DatapoolEncryptManager.encryptDatapool((IDatapool)datapool, (String)password);
            }
        }
        return false;
    }
}

